/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.flink.algorithms.fsm.transactional.tle.canonicalization;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.gradoop.flink.algorithms.fsm.transactional.tle.pojos.Embedding;
import org.gradoop.flink.algorithms.fsm.transactional.tle.pojos.FSMEdge;

public class CanonicalLabeler
implements Serializable {
    private static final char NEW_LIST = '|';
    private static final char LIST_START = ':';
    private static final char NEW_ENTRY = ',';
    private static final char OUTGOING_EDGE = '>';
    private static final char INCOMING_EDGE = '<';
    private static final char UNDIRECTED_EDGE = '-';
    private final boolean directed;

    public CanonicalLabeler(boolean directed) {
        this.directed = directed;
    }

    public String label(Embedding embedding) {
        Map<Integer, String> vertices = embedding.getVertices();
        Map<Integer, FSMEdge> edges = embedding.getEdges();
        Map<Integer, Map<Integer, Set<Integer>>> adjacencyMatrix = this.createAdjacencyMatrix(vertices, edges);
        ArrayList adjacencyListLabels = Lists.newArrayListWithCapacity((int)vertices.size());
        for (Map.Entry<Integer, String> vertex : vertices.entrySet()) {
            int vertexId = vertex.getKey();
            String adjacencyListLabel = vertex.getValue() + ':';
            Map<Integer, Set<Integer>> adjacencyList = adjacencyMatrix.get(vertexId);
            ArrayList entryLabels = Lists.newArrayListWithCapacity((int)adjacencyList.size());
            for (Map.Entry<Integer, Set<Integer>> entry : adjacencyList.entrySet()) {
                int adjacentVertexId = entry.getKey();
                String entryLabel = vertices.get(adjacentVertexId);
                Set<Integer> incidentEdgeIds = entry.getValue();
                if (incidentEdgeIds.size() == 1) {
                    FSMEdge incidentEdge = edges.get(incidentEdgeIds.iterator().next());
                    entryLabel = entryLabel + this.format(incidentEdge, vertexId);
                } else {
                    ArrayList incidentEdges = Lists.newArrayListWithExpectedSize((int)incidentEdgeIds.size());
                    for (int incidentEdgeId : incidentEdgeIds) {
                        incidentEdges.add(this.format(edges.get(incidentEdgeId), vertexId));
                    }
                    Collections.sort(incidentEdges);
                    entryLabel = entryLabel + StringUtils.join((Collection)incidentEdges, (String)"");
                }
                entryLabels.add(entryLabel);
            }
            Collections.sort(entryLabels);
            adjacencyListLabel = adjacencyListLabel + StringUtils.join((Collection)entryLabels, (char)',');
            adjacencyListLabels.add(adjacencyListLabel);
        }
        Collections.sort(adjacencyListLabels);
        return StringUtils.join((Collection)adjacencyListLabels, (char)'|');
    }

    private Map<Integer, Map<Integer, Set<Integer>>> createAdjacencyMatrix(Map<Integer, String> vertices, Map<Integer, FSMEdge> edges) {
        HashMap adjacencyMatrix = Maps.newHashMapWithExpectedSize((int)vertices.size());
        for (Map.Entry<Integer, FSMEdge> edgeEntry : edges.entrySet()) {
            int edgeId = edgeEntry.getKey();
            FSMEdge edge = edgeEntry.getValue();
            int sourceId = edge.getSourceId();
            int targetId = edge.getTargetId();
            this.addAdjacencyMatrixEntry(adjacencyMatrix, sourceId, edgeId, targetId);
            if (sourceId == targetId) continue;
            this.addAdjacencyMatrixEntry(adjacencyMatrix, targetId, edgeId, sourceId);
        }
        return adjacencyMatrix;
    }

    private void addAdjacencyMatrixEntry(Map<Integer, Map<Integer, Set<Integer>>> adjacencyMatrix, int vertexId, int incidentEdgeId, int adjacentVertexId) {
        Set incidentEdgeIds;
        HashMap adjacencyList = adjacencyMatrix.get(vertexId);
        if (adjacencyList == null) {
            adjacencyList = Maps.newHashMap();
            adjacencyMatrix.put(vertexId, adjacencyList);
        }
        if ((incidentEdgeIds = (Set)adjacencyList.get(adjacentVertexId)) == null) {
            adjacencyList.put(adjacentVertexId, Sets.newHashSet((Object[])new Integer[]{incidentEdgeId}));
        } else {
            incidentEdgeIds.add(incidentEdgeId);
        }
    }

    private String format(FSMEdge edge, int adjacencyListVertexId) {
        char edgeChar = this.directed ? (edge.getSourceId() == adjacencyListVertexId ? (char)'>' : '<') : (char)'-';
        return edgeChar + edge.getLabel();
    }
}

