/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.flink.algorithms.fsm.transactional.tle.functions;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.flink.api.common.functions.RichGroupReduceFunction;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.util.Collector;
import org.gradoop.flink.algorithms.fsm.transactional.tle.interestingness.Interestingness;
import org.gradoop.flink.algorithms.fsm.transactional.tle.tuples.CCSSubgraph;

public class CategoryFrequentAndInteresting
extends RichGroupReduceFunction<CCSSubgraph, CCSSubgraph> {
    private final Interestingness interestingness;
    private Map<String, Long> categoryMinFrequencies;
    private Map<String, Long> categoryCounts;

    public CategoryFrequentAndInteresting(float minInterestingness) {
        this.interestingness = new Interestingness(minInterestingness);
    }

    public void open(Configuration parameters) throws Exception {
        super.open(parameters);
        this.categoryMinFrequencies = (Map)this.getRuntimeContext().getBroadcastVariable("fmin").get(0);
        this.categoryCounts = (Map)this.getRuntimeContext().getBroadcastVariable("graphCount").get(0);
    }

    public void reduce(Iterable<CCSSubgraph> values, Collector<CCSSubgraph> out) throws Exception {
        ArrayList subgraphs = Lists.newArrayList();
        boolean onceFrequent = false;
        HashMap categorySupports = Maps.newHashMap();
        float avgSupport = 0.0f;
        for (CCSSubgraph subgraph : values) {
            subgraphs.add(subgraph);
            String category = subgraph.getCategory();
            long categoryFrequency = subgraph.getCount();
            float categorySupport = (float)categoryFrequency / (float)this.categoryCounts.get(category).longValue();
            avgSupport += categorySupport;
            categorySupports.put(category, Float.valueOf(categorySupport));
            if (categoryFrequency < this.categoryMinFrequencies.get(category) || onceFrequent) continue;
            onceFrequent = true;
        }
        if (onceFrequent) {
            avgSupport /= (float)this.categoryMinFrequencies.size();
            for (CCSSubgraph subgraph : subgraphs) {
                float categorySupport = ((Float)categorySupports.get(subgraph.getCategory())).floatValue();
                subgraph.setInteresting(this.interestingness.isInteresting(categorySupport, avgSupport));
                out.collect((Object)subgraph);
            }
        }
    }
}

