/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.flink.algorithms.fsm.transactional.tle.functions;

import java.util.HashMap;
import java.util.Map;
import org.apache.flink.api.common.functions.GroupReduceFunction;
import org.apache.flink.hadoop.shaded.com.google.common.collect.Maps;
import org.apache.flink.util.Collector;
import org.gradoop.flink.model.impl.tuples.WithCount;

public class CategoryGraphCounts
implements GroupReduceFunction<WithCount<String>, Map<String, Long>> {
    public void reduce(Iterable<WithCount<String>> categoriesWithCount, Collector<Map<String, Long>> out) throws Exception {
        HashMap categoryCounts = Maps.newHashMap();
        for (WithCount<String> categoryWithCount : categoriesWithCount) {
            String category = categoryWithCount.getObject();
            long count = categoryWithCount.getCount();
            Long sum = (Long)categoryCounts.get(category);
            sum = sum == null ? Long.valueOf(count) : Long.valueOf(sum + count);
            categoryCounts.put(category, sum);
        }
        out.collect((Object)categoryCounts);
    }
}

