/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.flink.algorithms.fsm.transactional.tle.functions;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.apache.flink.api.common.functions.FlatJoinFunction;
import org.apache.flink.api.common.functions.FlatMapFunction;
import org.apache.flink.util.Collector;
import org.gradoop.flink.algorithms.fsm.transactional.common.FSMConfig;
import org.gradoop.flink.algorithms.fsm.transactional.tle.canonicalization.CanonicalLabeler;
import org.gradoop.flink.algorithms.fsm.transactional.tle.pojos.Embedding;
import org.gradoop.flink.algorithms.fsm.transactional.tle.pojos.FSMEdge;
import org.gradoop.flink.algorithms.fsm.transactional.tle.pojos.FSMGraph;
import org.gradoop.flink.algorithms.fsm.transactional.tle.tuples.SubgraphEmbeddings;

public class JoinEmbeddings<G extends FSMGraph, SE extends SubgraphEmbeddings>
implements FlatJoinFunction<SE, G, SE>,
FlatMapFunction<SE, SE> {
    private final CanonicalLabeler canonicalLabeler;

    public JoinEmbeddings(FSMConfig fsmConfig) {
        this.canonicalLabeler = new CanonicalLabeler(fsmConfig.isDirected());
    }

    public void join(SE embeddings, G graph, Collector<SE> out) throws Exception {
        HashSet edgeSets = Sets.newHashSet();
        HashMap subgraphEmbeddings = Maps.newHashMap();
        for (Embedding parent : embeddings.getEmbeddings()) {
            for (Map.Entry<Integer, FSMEdge> entry : graph.getEdges().entrySet()) {
                String canonicalLabel;
                List siblings;
                int edgeId = entry.getKey();
                if (parent.getEdges().containsKey(edgeId)) continue;
                FSMEdge edge = entry.getValue();
                int sourceId = edge.getSourceId();
                boolean containsSourceId = parent.getVertices().containsKey(sourceId);
                int targetId = edge.getTargetId();
                boolean containsTargetId = parent.getVertices().containsKey(targetId);
                if (!containsSourceId && !containsTargetId) continue;
                TreeSet edgeSet = Sets.newTreeSet(parent.getEdgeIds());
                edgeSet.add(edgeId);
                if (edgeSets.contains(edgeSet)) continue;
                edgeSets.add(edgeSet);
                Embedding child = parent.deepCopy();
                child.getEdges().put(edgeId, edge);
                if (!containsSourceId) {
                    child.getVertices().put(sourceId, graph.getVertices().get(sourceId));
                }
                if (!containsTargetId) {
                    child.getVertices().put(targetId, graph.getVertices().get(targetId));
                }
                if ((siblings = (List)subgraphEmbeddings.get(canonicalLabel = this.canonicalLabeler.label(child))) == null) {
                    siblings = Lists.newArrayList((Object[])new Embedding[]{child});
                    subgraphEmbeddings.put(canonicalLabel, siblings);
                    continue;
                }
                siblings.add(child);
            }
        }
        this.collect(embeddings, out, subgraphEmbeddings);
    }

    public void flatMap(SE embeddings, Collector<SE> collector) throws Exception {
        Map<String, List<Embedding>> subgraphEmbeddings = embeddings.getSize() == 1 ? this.joinOnVertex(embeddings) : this.joinOnEdgeOverlap(embeddings);
        this.collect(embeddings, collector, subgraphEmbeddings);
    }

    private Map<String, List<Embedding>> joinOnEdgeOverlap(SE embeddings) {
        HashMap subgraphEmbeddings = Maps.newHashMap();
        List<Embedding> parents = embeddings.getEmbeddings();
        HashSet edgeSets = Sets.newHashSet();
        HashMap subsetParents = Maps.newHashMap();
        int parentIndex = 0;
        for (Embedding parent : parents) {
            for (Integer edgeId : parent.getEdgeIds()) {
                TreeSet subset = Sets.newTreeSet(parent.getEdgeIds());
                subset.remove(edgeId);
                Collection siblings = (Collection)subsetParents.get(subset);
                if (siblings == null) {
                    subsetParents.put(subset, Lists.newArrayList((Object[])new Integer[]{parentIndex}));
                    continue;
                }
                siblings.add(parentIndex);
            }
            ++parentIndex;
        }
        for (List overlappingParents : subsetParents.values()) {
            int size = overlappingParents.size();
            if (size <= 1) continue;
            for (int i = 0; i < size - 1; ++i) {
                for (int j = i + 1; j < size; ++j) {
                    Embedding left = parents.get((Integer)overlappingParents.get(i));
                    Embedding right = parents.get((Integer)overlappingParents.get(j));
                    TreeSet edgeSet = Sets.newTreeSet(left.getEdgeIds());
                    edgeSet.addAll(right.getEdgeIds());
                    if (edgeSets.contains(edgeSet)) continue;
                    edgeSets.add(edgeSet);
                    Embedding child = left.deepCopy();
                    child.getVertices().putAll(right.getVertices());
                    child.getEdges().putAll(right.getEdges());
                    String canonicalLabel = this.canonicalLabeler.label(child);
                    List siblings = (List)subgraphEmbeddings.get(canonicalLabel);
                    if (siblings == null) {
                        siblings = Lists.newArrayList((Object[])new Embedding[]{child});
                        subgraphEmbeddings.put(canonicalLabel, siblings);
                        continue;
                    }
                    siblings.add(child);
                }
            }
        }
        return subgraphEmbeddings;
    }

    private Map<String, List<Embedding>> joinOnVertex(SE embeddings) {
        HashMap subgraphEmbeddings = Maps.newHashMap();
        List<Embedding> parents = embeddings.getEmbeddings();
        int size = parents.size();
        for (int i = 0; i < size - 1; ++i) {
            for (int j = i + 1; j < size; ++j) {
                Embedding left = parents.get(i);
                Embedding right = parents.get(j);
                FSMEdge leftEdge = left.getEdges().values().iterator().next();
                FSMEdge rightEdge = right.getEdges().values().iterator().next();
                if (leftEdge.getSourceId() != rightEdge.getSourceId() && leftEdge.getSourceId() != rightEdge.getTargetId() && leftEdge.getTargetId() != rightEdge.getSourceId() && leftEdge.getTargetId() != rightEdge.getTargetId()) continue;
                Embedding child = left.deepCopy();
                child.getVertices().putAll(right.getVertices());
                child.getEdges().putAll(right.getEdges());
                String canonicalLabel = this.canonicalLabeler.label(child);
                List siblings = (List)subgraphEmbeddings.get(canonicalLabel);
                if (siblings == null) {
                    siblings = Lists.newArrayList((Object[])new Embedding[]{child});
                    subgraphEmbeddings.put(canonicalLabel, siblings);
                    continue;
                }
                siblings.add(child);
            }
        }
        return subgraphEmbeddings;
    }

    private void collect(SE reuseTuple, Collector<SE> out, Map<String, List<Embedding>> subgraphEmbeddings) {
        reuseTuple.setSize(reuseTuple.getSize() + 1);
        for (Map.Entry<String, List<Embedding>> entry : subgraphEmbeddings.entrySet()) {
            reuseTuple.setCanonicalLabel(entry.getKey());
            reuseTuple.setEmbeddings(entry.getValue());
            out.collect(reuseTuple);
        }
    }
}

