/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.flink.algorithms.fsm.transactional.tle.functions;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gradoop.flink.algorithms.fsm.transactional.common.FSMConfig;
import org.gradoop.flink.algorithms.fsm.transactional.tle.canonicalization.CanonicalLabeler;
import org.gradoop.flink.algorithms.fsm.transactional.tle.pojos.Embedding;
import org.gradoop.flink.algorithms.fsm.transactional.tle.pojos.FSMEdge;
import org.gradoop.flink.algorithms.fsm.transactional.tle.pojos.FSMGraph;

public abstract class SingleEdgeEmbeddings
implements Serializable {
    protected CanonicalLabeler canonicalLabeler;

    public SingleEdgeEmbeddings(FSMConfig fsmConfig) {
        this.canonicalLabeler = new CanonicalLabeler(fsmConfig.isDirected());
    }

    protected Map<String, List<Embedding>> createEmbeddings(FSMGraph graph) {
        Map<Integer, String> vertices = graph.getVertices();
        HashMap subgraphEmbeddings = Maps.newHashMap();
        for (Map.Entry<Integer, FSMEdge> entry : graph.getEdges().entrySet()) {
            FSMEdge edge = entry.getValue();
            int sourceId = edge.getSourceId();
            int targetId = edge.getTargetId();
            HashMap incidentVertices = Maps.newHashMapWithExpectedSize((int)2);
            incidentVertices.put(sourceId, vertices.get(sourceId));
            if (sourceId != targetId) {
                incidentVertices.put(targetId, vertices.get(targetId));
            }
            HashMap singleEdge = Maps.newHashMapWithExpectedSize((int)1);
            singleEdge.put(entry.getKey(), edge);
            Embedding embedding = new Embedding(incidentVertices, singleEdge);
            String subgraph = this.canonicalLabeler.label(embedding);
            List embeddings = (List)subgraphEmbeddings.get(subgraph);
            if (embeddings == null) {
                subgraphEmbeddings.put(subgraph, Lists.newArrayList((Object[])new Embedding[]{embedding}));
                continue;
            }
            embeddings.add(embedding);
        }
        return subgraphEmbeddings;
    }
}

