/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.flink.algorithms.fsm.transactional.tle.functions;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.gradoop.common.model.api.entities.EdgeFactory;
import org.gradoop.common.model.api.entities.GraphHeadFactory;
import org.gradoop.common.model.api.entities.VertexFactory;
import org.gradoop.common.model.impl.id.GradoopId;
import org.gradoop.common.model.impl.id.GradoopIdSet;
import org.gradoop.common.model.impl.pojo.EPGMEdge;
import org.gradoop.common.model.impl.pojo.EPGMGraphHead;
import org.gradoop.common.model.impl.pojo.EPGMVertex;
import org.gradoop.common.model.impl.properties.Properties;
import org.gradoop.flink.algorithms.fsm.transactional.tle.pojos.FSMEdge;
import org.gradoop.flink.algorithms.fsm.transactional.tle.tuples.Subgraph;
import org.gradoop.flink.model.impl.layouts.transactional.tuples.GraphTransaction;
import org.gradoop.flink.util.GradoopFlinkConfig;

public abstract class SubgraphDecoder
implements Serializable {
    protected final GraphHeadFactory<EPGMGraphHead> graphHeadFactory;
    protected final VertexFactory<EPGMVertex> vertexFactory;
    protected final EdgeFactory<EPGMEdge> edgeFactory;

    public SubgraphDecoder(GradoopFlinkConfig config) {
        this.vertexFactory = config.getLogicalGraphFactory().getVertexFactory();
        this.graphHeadFactory = config.getLogicalGraphFactory().getGraphHeadFactory();
        this.edgeFactory = config.getLogicalGraphFactory().getEdgeFactory();
    }

    protected GraphTransaction createTransaction(Subgraph subgraph, String canonicalLabel) {
        Properties properties = new Properties();
        properties.set("frequency", (Object)subgraph.getCount());
        properties.set("canonicalLabel", (Object)subgraph.getCanonicalLabel());
        EPGMGraphHead epgmGraphHead = (EPGMGraphHead)this.graphHeadFactory.createGraphHead(canonicalLabel, properties);
        GradoopIdSet graphIds = GradoopIdSet.fromExisting((GradoopId[])new GradoopId[]{epgmGraphHead.getId()});
        Map<Integer, String> vertices = subgraph.getEmbedding().getVertices();
        HashSet epgmVertices = Sets.newHashSetWithExpectedSize((int)vertices.size());
        HashMap vertexIdMap = Maps.newHashMapWithExpectedSize((int)vertices.size());
        for (Map.Entry<Integer, String> vertex : vertices.entrySet()) {
            EPGMVertex epgmVertex = (EPGMVertex)this.vertexFactory.createVertex(vertex.getValue(), graphIds);
            vertexIdMap.put(vertex.getKey(), epgmVertex.getId());
            epgmVertices.add(epgmVertex);
        }
        Collection<FSMEdge> edges = subgraph.getEmbedding().getEdges().values();
        HashSet epgmEdges = Sets.newHashSetWithExpectedSize((int)edges.size());
        for (FSMEdge edge : edges) {
            epgmEdges.add(this.edgeFactory.createEdge(edge.getLabel(), (GradoopId)vertexIdMap.get(edge.getSourceId()), (GradoopId)vertexIdMap.get(edge.getTargetId()), graphIds));
        }
        return new GraphTransaction(epgmGraphHead, epgmVertices, epgmEdges);
    }
}

