/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.flink.algorithms.fsm.transactional.tle.functions;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import org.gradoop.common.model.impl.id.GradoopId;
import org.gradoop.common.model.impl.pojo.EPGMEdge;
import org.gradoop.common.model.impl.pojo.EPGMVertex;
import org.gradoop.flink.algorithms.fsm.transactional.tle.pojos.FSMEdge;
import org.gradoop.flink.model.impl.layouts.transactional.tuples.GraphTransaction;

public abstract class ToFSMGraph {
    protected Map<Integer, String> transformVertices(GraphTransaction graph, Map<GradoopId, Integer> vertexIdMap) {
        HashMap fsmVertices = Maps.newHashMapWithExpectedSize((int)graph.getVertices().size());
        int vertexId = 0;
        for (EPGMVertex vertex : graph.getVertices()) {
            vertexIdMap.put(vertex.getId(), vertexId);
            fsmVertices.put(vertexId, vertex.getLabel());
            ++vertexId;
        }
        return fsmVertices;
    }

    protected Map<Integer, FSMEdge> transformEdges(GraphTransaction graph, Map<GradoopId, Integer> vertexIdMap) {
        HashMap fsmEdges = Maps.newHashMapWithExpectedSize((int)graph.getEdges().size());
        int edgeId = 0;
        for (EPGMEdge edge : graph.getEdges()) {
            int sourceId = vertexIdMap.get(edge.getSourceId());
            int targetId = vertexIdMap.get(edge.getTargetId());
            fsmEdges.put(edgeId, new FSMEdge(sourceId, edge.getLabel(), targetId));
            ++edgeId;
        }
        return fsmEdges;
    }
}

