/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.flink.algorithms.fsm.transactional.tle.functions;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.apache.flink.api.common.functions.RichMapFunction;
import org.apache.flink.configuration.Configuration;
import org.gradoop.flink.algorithms.fsm.transactional.tle.pojos.FSMEdge;
import org.gradoop.flink.algorithms.fsm.transactional.tle.pojos.FSMGraph;

public class WithoutInfrequentEdgeLabels<G extends FSMGraph>
extends RichMapFunction<G, G> {
    private Collection<String> frequentEdgeLabels;

    public void open(Configuration parameters) throws Exception {
        super.open(parameters);
        this.frequentEdgeLabels = this.getRuntimeContext().getBroadcastVariable("fel");
        this.frequentEdgeLabels = Sets.newHashSet(this.frequentEdgeLabels);
    }

    public G map(G value) throws Exception {
        HashSet connectedVertexIds = Sets.newHashSet();
        Iterator<Map.Entry<Integer, FSMEdge>> edgeIterator = value.getEdges().entrySet().iterator();
        while (edgeIterator.hasNext()) {
            FSMEdge edge = edgeIterator.next().getValue();
            if (this.frequentEdgeLabels.contains(edge.getLabel())) {
                connectedVertexIds.add(edge.getSourceId());
                connectedVertexIds.add(edge.getTargetId());
                continue;
            }
            edgeIterator.remove();
        }
        Iterator<Map.Entry<Integer, String>> vertexIterator = value.getVertices().entrySet().iterator();
        while (vertexIterator.hasNext()) {
            Map.Entry<Integer, String> vertex = vertexIterator.next();
            if (connectedVertexIds.contains(vertex.getKey())) continue;
            vertexIterator.remove();
        }
        return value;
    }
}

