/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.flink.algorithms.fsm.transactional.tle.functions;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.apache.flink.api.common.functions.RichMapFunction;
import org.apache.flink.configuration.Configuration;
import org.gradoop.flink.algorithms.fsm.transactional.tle.pojos.FSMEdge;
import org.gradoop.flink.algorithms.fsm.transactional.tle.pojos.FSMGraph;

public class WithoutInfrequentVertexLabels<G extends FSMGraph>
extends RichMapFunction<G, G> {
    private Collection<String> frequentVertexLabels;

    public void open(Configuration parameters) throws Exception {
        super.open(parameters);
        this.frequentVertexLabels = this.getRuntimeContext().getBroadcastVariable("fvl");
        this.frequentVertexLabels = Sets.newHashSet(this.frequentVertexLabels);
    }

    public G map(G value) throws Exception {
        HashSet keptVertexIds = Sets.newHashSet();
        Iterator<Map.Entry<Integer, String>> vertexIterator = value.getVertices().entrySet().iterator();
        while (vertexIterator.hasNext()) {
            Map.Entry<Integer, String> vertex = vertexIterator.next();
            if (this.frequentVertexLabels.contains(vertex.getValue())) {
                keptVertexIds.add(vertex.getKey());
                continue;
            }
            vertexIterator.remove();
        }
        Iterator<Map.Entry<Integer, FSMEdge>> edgeIterator = value.getEdges().entrySet().iterator();
        while (edgeIterator.hasNext()) {
            FSMEdge edge = edgeIterator.next().getValue();
            if (keptVertexIds.contains(edge.getSourceId()) && keptVertexIds.contains(edge.getTargetId())) continue;
            edgeIterator.remove();
        }
        return value;
    }
}

