/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.flink.algorithms.fsm.transactional.tle.pojos;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.gradoop.flink.algorithms.fsm.transactional.tle.pojos.FSMEdge;

public class Embedding {
    private final Map<Integer, String> vertices;
    private final Map<Integer, FSMEdge> edges;

    public Embedding(Map<Integer, String> vertices, Map<Integer, FSMEdge> edges) {
        this.vertices = vertices;
        this.edges = edges;
    }

    public Embedding combine(Embedding that) {
        HashMap commonVertices = Maps.newHashMap(this.vertices);
        commonVertices.putAll(that.getVertices());
        HashMap commonEdges = Maps.newHashMapWithExpectedSize((int)(this.edges.size() + that.getEdges().size()));
        commonEdges.putAll(this.edges);
        commonEdges.putAll(that.getEdges());
        return new Embedding(commonVertices, commonEdges);
    }

    public Map<Integer, String> getVertices() {
        return this.vertices;
    }

    public String toString() {
        return this.vertices.toString() + "|" + this.edges.toString();
    }

    public Map<Integer, FSMEdge> getEdges() {
        return this.edges;
    }

    public Set<Integer> getEdgeIds() {
        return this.edges.keySet();
    }

    public Embedding deepCopy() {
        return new Embedding(Maps.newHashMap(this.vertices), Maps.newHashMap(this.edges));
    }
}

