/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.flink.algorithms.gelly;

import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.api.java.operators.MapOperator;
import org.apache.flink.graph.Graph;
import org.gradoop.common.model.impl.id.GradoopId;
import org.gradoop.flink.algorithms.gelly.BaseGellyAlgorithm;
import org.gradoop.flink.algorithms.gelly.functions.EdgeToGellyEdge;
import org.gradoop.flink.algorithms.gelly.functions.VertexToGellyVertex;
import org.gradoop.flink.model.api.operators.UnaryGraphToGraphOperator;
import org.gradoop.flink.model.impl.epgm.LogicalGraph;

public abstract class GradoopGellyAlgorithm<VV, EV>
extends BaseGellyAlgorithm<GradoopId, VV, EV, LogicalGraph>
implements UnaryGraphToGraphOperator {
    protected LogicalGraph currentGraph;
    private final EdgeToGellyEdge<EV> toGellyEdge;
    private final VertexToGellyVertex<VV> toGellyVertex;

    protected GradoopGellyAlgorithm(VertexToGellyVertex<VV> vertexValue, EdgeToGellyEdge<EV> edgeValue) {
        this.toGellyVertex = vertexValue;
        this.toGellyEdge = edgeValue;
    }

    @Override
    public LogicalGraph execute(LogicalGraph graph) {
        this.currentGraph = graph;
        try {
            return this.executeInGelly((Graph)this.transformToGelly(graph));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Graph<GradoopId, VV, EV> transformToGelly(LogicalGraph graph) {
        MapOperator gellyVertices = graph.getVertices().map(this.toGellyVertex);
        MapOperator gellyEdges = graph.getEdges().map(this.toGellyEdge);
        return Graph.fromDataSet((DataSet)gellyVertices, (DataSet)gellyEdges, (ExecutionEnvironment)graph.getConfig().getExecutionEnvironment());
    }

    @Override
    public abstract LogicalGraph executeInGelly(Graph<GradoopId, VV, EV> var1) throws Exception;
}

