/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.flink.algorithms.gelly.connectedcomponents;

import org.apache.flink.api.common.functions.JoinFunction;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.operators.JoinOperator;
import org.apache.flink.graph.Graph;
import org.apache.flink.graph.library.ConnectedComponents;
import org.apache.flink.types.NullValue;
import org.gradoop.common.model.impl.id.GradoopId;
import org.gradoop.common.model.impl.pojo.EPGMEdge;
import org.gradoop.common.model.impl.pojo.EPGMVertex;
import org.gradoop.flink.algorithms.gelly.GradoopGellyAlgorithm;
import org.gradoop.flink.algorithms.gelly.connectedcomponents.functions.GellyVertexValueToVertexPropertyJoin;
import org.gradoop.flink.algorithms.gelly.connectedcomponents.functions.VertexPropertyToEdgePropertyJoin;
import org.gradoop.flink.algorithms.gelly.functions.EdgeToGellyEdgeWithNullValue;
import org.gradoop.flink.algorithms.gelly.functions.VertexToGellyVertexWithGradoopId;
import org.gradoop.flink.model.impl.epgm.LogicalGraph;
import org.gradoop.flink.model.impl.functions.epgm.Id;
import org.gradoop.flink.model.impl.functions.epgm.SourceId;
import org.gradoop.flink.model.impl.functions.epgm.TargetId;

public class AnnotateWeaklyConnectedComponents
extends GradoopGellyAlgorithm<GradoopId, NullValue> {
    private final String propertyKey;
    private final int maxIterations;
    private final boolean annotateEdges;

    public AnnotateWeaklyConnectedComponents(String propertyKey, int maxIterations) {
        super(new VertexToGellyVertexWithGradoopId(), new EdgeToGellyEdgeWithNullValue());
        this.propertyKey = propertyKey;
        this.maxIterations = maxIterations;
        this.annotateEdges = false;
    }

    public AnnotateWeaklyConnectedComponents(String propertyKey, int maxIterations, boolean annotateEdges) {
        super(new VertexToGellyVertexWithGradoopId(), new EdgeToGellyEdgeWithNullValue());
        this.propertyKey = propertyKey;
        this.maxIterations = maxIterations;
        this.annotateEdges = annotateEdges;
    }

    @Override
    public LogicalGraph executeInGelly(Graph<GradoopId, GradoopId, NullValue> graph) throws Exception {
        JoinOperator.EquiJoin annotatedVertices = new ConnectedComponents(Integer.valueOf(this.maxIterations)).run(graph).join(this.currentGraph.getVertices()).where(new int[]{0}).equalTo(new Id()).with((JoinFunction)new GellyVertexValueToVertexPropertyJoin(this.propertyKey));
        JoinOperator.EquiJoin edges = this.currentGraph.getEdges();
        if (this.annotateEdges) {
            edges = edges.join((DataSet)annotatedVertices).where(new SourceId()).equalTo(new Id()).with((JoinFunction)new VertexPropertyToEdgePropertyJoin(this.propertyKey)).join((DataSet)annotatedVertices).where(new TargetId()).equalTo(new Id()).with((JoinFunction)new VertexPropertyToEdgePropertyJoin(this.propertyKey));
        }
        return this.currentGraph.getFactory().fromDataSets(this.currentGraph.getGraphHead(), (DataSet<EPGMVertex>)annotatedVertices, (DataSet<EPGMEdge>)edges);
    }
}

