/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.flink.algorithms.gelly.connectedcomponents;

import org.apache.flink.api.common.functions.JoinFunction;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.api.java.operators.MapOperator;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.api.java.utils.DataSetUtils;
import org.apache.flink.graph.Graph;
import org.apache.flink.graph.library.ConnectedComponents;
import org.apache.flink.types.NullValue;
import org.gradoop.flink.algorithms.gelly.BaseGellyAlgorithm;
import org.gradoop.flink.algorithms.gelly.connectedcomponents.functions.CreateLongSourceIds;
import org.gradoop.flink.algorithms.gelly.connectedcomponents.functions.CreateLongTargetIds;
import org.gradoop.flink.algorithms.gelly.connectedcomponents.functions.MapVertexIdComponentId;
import org.gradoop.flink.algorithms.gelly.functions.LongTupleToGellyEdgeWithLongValue;
import org.gradoop.flink.algorithms.gelly.functions.LongTupleToGellyVertexWithLongValue;
import org.gradoop.flink.model.impl.epgm.LogicalGraph;
import org.gradoop.flink.model.impl.functions.epgm.Id;
import org.gradoop.flink.model.impl.functions.epgm.SourceId;

public class ValueWeaklyConnectedComponents
extends BaseGellyAlgorithm<Long, Long, NullValue, DataSet<Tuple2<Long, Long>>> {
    private int maxIteration;

    public ValueWeaklyConnectedComponents(int maxIteration) {
        this.maxIteration = maxIteration;
    }

    @Override
    public Graph<Long, Long, NullValue> transformToGelly(LogicalGraph graph) {
        DataSet uniqueVertexID = DataSetUtils.zipWithUniqueId((DataSet)graph.getVertices().map(new Id()));
        MapOperator vertices = uniqueVertexID.map((MapFunction)new LongTupleToGellyVertexWithLongValue());
        MapOperator edges = uniqueVertexID.join(graph.getEdges()).where(new int[]{1}).equalTo(new SourceId()).with((JoinFunction)new CreateLongSourceIds()).join(uniqueVertexID).where(new int[]{3}).equalTo(new int[]{1}).with((JoinFunction)new CreateLongTargetIds()).map((MapFunction)new LongTupleToGellyEdgeWithLongValue());
        return Graph.fromDataSet((DataSet)vertices, (DataSet)edges, (ExecutionEnvironment)graph.getConfig().getExecutionEnvironment());
    }

    @Override
    public DataSet<Tuple2<Long, Long>> executeInGelly(Graph<Long, Long, NullValue> graph) throws Exception {
        return new ConnectedComponents(Integer.valueOf(this.maxIteration)).run(graph).map((MapFunction)new MapVertexIdComponentId());
    }
}

