/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.flink.algorithms.gelly.connectedcomponents;

import org.gradoop.flink.algorithms.gelly.connectedcomponents.AnnotateWeaklyConnectedComponents;
import org.gradoop.flink.model.api.operators.UnaryGraphToCollectionOperator;
import org.gradoop.flink.model.impl.epgm.GraphCollection;
import org.gradoop.flink.model.impl.epgm.LogicalGraph;

public class WeaklyConnectedComponentsAsCollection
implements UnaryGraphToCollectionOperator {
    private static final String DEFAULT_PROPERTY_KEY = "wcc_component_id";
    private final String propertyKey;
    private final int maxIterations;

    public WeaklyConnectedComponentsAsCollection(int maxIterations) {
        this(DEFAULT_PROPERTY_KEY, maxIterations);
    }

    public WeaklyConnectedComponentsAsCollection(String propertyKey, int maxIterations) {
        this.propertyKey = propertyKey;
        this.maxIterations = maxIterations;
    }

    @Override
    public GraphCollection execute(LogicalGraph graph) {
        LogicalGraph graphWithWccIds = graph.callForGraph(new AnnotateWeaklyConnectedComponents(this.propertyKey, this.maxIterations));
        return graphWithWccIds.splitBy(this.propertyKey);
    }
}

