/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.flink.algorithms.gelly.functions;

import org.apache.flink.api.java.functions.FunctionAnnotation;
import org.apache.flink.graph.Edge;
import org.gradoop.common.model.impl.id.GradoopId;
import org.gradoop.common.model.impl.pojo.EPGMEdge;
import org.gradoop.common.model.impl.properties.PropertyValue;
import org.gradoop.flink.algorithms.gelly.functions.EdgeToGellyEdge;

@FunctionAnnotation.ForwardedFields(value={"sourceId->f0;targetId->f1"})
@FunctionAnnotation.ReadFields(value={"properties"})
public class EdgeToGellyEdgeWithPropertyValue
implements EdgeToGellyEdge<PropertyValue> {
    private final String propertyKey;
    private final Edge<GradoopId, PropertyValue> reuseEdge;

    public EdgeToGellyEdgeWithPropertyValue(String propertyKey) {
        this.propertyKey = propertyKey;
        this.reuseEdge = new Edge();
    }

    public Edge<GradoopId, PropertyValue> map(EPGMEdge epgmEdge) {
        this.reuseEdge.setSource((Object)epgmEdge.getSourceId());
        this.reuseEdge.setTarget((Object)epgmEdge.getTargetId());
        this.reuseEdge.setValue((Object)epgmEdge.getPropertyValue(this.propertyKey));
        return this.reuseEdge;
    }
}

