/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.flink.algorithms.gelly.hits;

import org.apache.flink.api.common.functions.JoinFunction;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.api.java.operators.JoinOperator;
import org.apache.flink.graph.Graph;
import org.apache.flink.types.NullValue;
import org.gradoop.common.model.impl.id.GradoopId;
import org.gradoop.common.model.impl.pojo.EPGMVertex;
import org.gradoop.flink.algorithms.gelly.GradoopGellyAlgorithm;
import org.gradoop.flink.algorithms.gelly.functions.EdgeToGellyEdgeWithNullValue;
import org.gradoop.flink.algorithms.gelly.functions.VertexToGellyVertexWithNullValue;
import org.gradoop.flink.algorithms.gelly.hits.functions.HITSToAttributes;
import org.gradoop.flink.algorithms.gelly.hits.functions.HitsResultKeySelector;
import org.gradoop.flink.model.impl.epgm.LogicalGraph;
import org.gradoop.flink.model.impl.functions.epgm.Id;

public class HITS
extends GradoopGellyAlgorithm<NullValue, NullValue> {
    private String authorityPropertyKey;
    private String hubPropertyKey;
    private org.apache.flink.graph.library.linkanalysis.HITS<GradoopId, NullValue, NullValue> hits;

    public HITS(String authorityPropertyKey, String hubPropertyKey, int iterations) {
        super(new VertexToGellyVertexWithNullValue(), new EdgeToGellyEdgeWithNullValue());
        this.authorityPropertyKey = authorityPropertyKey;
        this.hubPropertyKey = hubPropertyKey;
        this.hits = new org.apache.flink.graph.library.linkanalysis.HITS(iterations, Double.MAX_VALUE);
    }

    public HITS(String authorityPropertyKey, String hubPropertyKey, double convergenceThreshold) {
        super(new VertexToGellyVertexWithNullValue(), new EdgeToGellyEdgeWithNullValue());
        this.authorityPropertyKey = authorityPropertyKey;
        this.hubPropertyKey = hubPropertyKey;
        this.hits = new org.apache.flink.graph.library.linkanalysis.HITS(Integer.MAX_VALUE, convergenceThreshold);
    }

    public HITS(String authorityPropertyKey, String hubPropertyKey, int maxIterations, double convergenceThreshold) {
        super(new VertexToGellyVertexWithNullValue(), new EdgeToGellyEdgeWithNullValue());
        this.authorityPropertyKey = authorityPropertyKey;
        this.hubPropertyKey = hubPropertyKey;
        this.hits = new org.apache.flink.graph.library.linkanalysis.HITS(maxIterations, convergenceThreshold);
    }

    @Override
    public LogicalGraph executeInGelly(Graph<GradoopId, NullValue, NullValue> graph) throws Exception {
        JoinOperator.EquiJoin newVertices = this.hits.runInternal(graph).join(this.currentGraph.getVertices()).where((KeySelector)new HitsResultKeySelector()).equalTo(new Id()).with((JoinFunction)new HITSToAttributes(this.authorityPropertyKey, this.hubPropertyKey));
        return this.currentGraph.getFactory().fromDataSets(this.currentGraph.getGraphHead(), (DataSet<EPGMVertex>)newVertices, this.currentGraph.getEdges());
    }
}

