/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.flink.algorithms.gelly.labelpropagation;

import com.google.common.base.Preconditions;
import org.apache.flink.api.common.functions.JoinFunction;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.operators.JoinOperator;
import org.apache.flink.graph.Graph;
import org.apache.flink.graph.Vertex;
import org.apache.flink.types.NullValue;
import org.gradoop.common.model.impl.id.GradoopId;
import org.gradoop.common.model.impl.pojo.EPGMVertex;
import org.gradoop.common.model.impl.properties.PropertyValue;
import org.gradoop.flink.algorithms.gelly.GradoopGellyAlgorithm;
import org.gradoop.flink.algorithms.gelly.functions.EdgeToGellyEdgeWithNullValue;
import org.gradoop.flink.algorithms.gelly.functions.VertexToGellyVertexWithPropertyValue;
import org.gradoop.flink.algorithms.gelly.labelpropagation.functions.LPVertexJoin;
import org.gradoop.flink.model.impl.epgm.LogicalGraph;
import org.gradoop.flink.model.impl.functions.epgm.Id;

public abstract class LabelPropagation
extends GradoopGellyAlgorithm<PropertyValue, NullValue> {
    private final int maxIterations;
    private final String propertyKey;

    protected LabelPropagation(int maxIterations, String propertyKey) {
        super(new VertexToGellyVertexWithPropertyValue(propertyKey), new EdgeToGellyEdgeWithNullValue());
        this.maxIterations = maxIterations;
        this.propertyKey = (String)Preconditions.checkNotNull((Object)propertyKey);
    }

    @Override
    public LogicalGraph executeInGelly(Graph<GradoopId, PropertyValue, NullValue> graph) {
        JoinOperator.EquiJoin labeledVertices = this.executeInternal(graph).join(this.currentGraph.getVertices()).where(new int[]{0}).equalTo(new Id()).with((JoinFunction)new LPVertexJoin(this.propertyKey));
        return this.currentGraph.getFactory().fromDataSets(this.currentGraph.getGraphHead(), (DataSet<EPGMVertex>)labeledVertices, this.currentGraph.getEdges());
    }

    protected abstract DataSet<Vertex<GradoopId, PropertyValue>> executeInternal(Graph<GradoopId, PropertyValue, NullValue> var1);

    protected int getMaxIterations() {
        return this.maxIterations;
    }
}

