/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.flink.algorithms.gelly.labelpropagation.functions;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.flink.graph.Vertex;
import org.apache.flink.graph.spargel.GatherFunction;
import org.apache.flink.graph.spargel.MessageIterator;
import org.apache.flink.hadoop.shaded.com.google.common.collect.Lists;
import org.gradoop.common.model.impl.id.GradoopId;
import org.gradoop.common.model.impl.properties.PropertyValue;

public class LPUpdateFunction
extends GatherFunction<GradoopId, PropertyValue, PropertyValue> {
    public void updateVertex(Vertex<GradoopId, PropertyValue> vertex, MessageIterator<PropertyValue> msg) {
        PropertyValue value = this.getNewValue(vertex, Lists.newArrayList((Iterator)msg.iterator()));
        if (!((PropertyValue)vertex.getValue()).equals((Object)value)) {
            this.setNewVertexValue(value);
        }
    }

    private PropertyValue getNewValue(Vertex<GradoopId, PropertyValue> vertex, List<PropertyValue> allMessages) {
        Collections.sort(allMessages);
        int currentCounter = 1;
        PropertyValue currentValue = allMessages.get(0);
        int maxCounter = 1;
        PropertyValue maxValue = PropertyValue.NULL_VALUE;
        for (int i = 1; i < allMessages.size(); ++i) {
            if (currentValue == allMessages.get(i)) {
                if (maxCounter >= ++currentCounter) continue;
                maxCounter = currentCounter;
                maxValue = currentValue;
                continue;
            }
            currentCounter = 1;
            currentValue = allMessages.get(i);
        }
        PropertyValue newValue = maxCounter == 1 ? this.getMinimum((PropertyValue)vertex.getValue(), allMessages.get(0)) : maxValue;
        return newValue;
    }

    private PropertyValue getMinimum(PropertyValue v1, PropertyValue v2) {
        int compare = v1.compareTo(v2);
        PropertyValue newValue = compare <= 0 ? v1 : v2;
        return newValue;
    }
}

