/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.flink.algorithms.gelly.pagerank;

import org.apache.flink.api.common.functions.JoinFunction;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.api.java.operators.JoinOperator;
import org.apache.flink.graph.Graph;
import org.apache.flink.types.NullValue;
import org.gradoop.common.model.impl.id.GradoopId;
import org.gradoop.common.model.impl.pojo.EPGMVertex;
import org.gradoop.flink.algorithms.gelly.GradoopGellyAlgorithm;
import org.gradoop.flink.algorithms.gelly.functions.EdgeToGellyEdgeWithNullValue;
import org.gradoop.flink.algorithms.gelly.functions.VertexToGellyVertexWithNullValue;
import org.gradoop.flink.algorithms.gelly.pagerank.functions.PageRankResultKey;
import org.gradoop.flink.algorithms.gelly.pagerank.functions.PageRankToAttribute;
import org.gradoop.flink.model.impl.epgm.LogicalGraph;
import org.gradoop.flink.model.impl.functions.epgm.Id;

public class PageRank
extends GradoopGellyAlgorithm<NullValue, NullValue> {
    private final String propertyKey;
    private final double dampingFactor;
    private final int iterations;
    private final boolean includeZeroDegrees;

    public PageRank(String propertyKey, double dampingFactor, int iterations) {
        this(propertyKey, dampingFactor, iterations, false);
    }

    public PageRank(String propertyKey, double dampingFactor, int iterations, boolean includeZeroDegrees) {
        super(new VertexToGellyVertexWithNullValue(), new EdgeToGellyEdgeWithNullValue());
        this.propertyKey = propertyKey;
        this.dampingFactor = dampingFactor;
        this.iterations = iterations;
        this.includeZeroDegrees = includeZeroDegrees;
    }

    @Override
    public LogicalGraph executeInGelly(Graph<GradoopId, NullValue, NullValue> graph) throws Exception {
        JoinOperator.EquiJoin newVertices = new org.apache.flink.graph.library.linkanalysis.PageRank(this.dampingFactor, this.iterations).setIncludeZeroDegreeVertices(this.includeZeroDegrees).run(graph).join(this.currentGraph.getVertices()).where((KeySelector)new PageRankResultKey()).equalTo(new Id()).with((JoinFunction)new PageRankToAttribute(this.propertyKey));
        return this.currentGraph.getFactory().fromDataSets(this.currentGraph.getGraphHead(), (DataSet<EPGMVertex>)newVertices, this.currentGraph.getEdges());
    }
}

