/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.flink.algorithms.gelly.randomjump;

import com.google.common.base.Preconditions;
import java.util.HashSet;
import org.apache.flink.api.common.aggregators.Aggregator;
import org.apache.flink.api.common.aggregators.LongSumAggregator;
import org.apache.flink.api.common.functions.FlatMapFunction;
import org.apache.flink.api.common.functions.JoinFunction;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.api.java.operators.DataSource;
import org.apache.flink.api.java.operators.DistinctOperator;
import org.apache.flink.api.java.operators.JoinOperator;
import org.apache.flink.api.java.operators.MapOperator;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.api.java.utils.DataSetUtils;
import org.apache.flink.graph.Graph;
import org.apache.flink.graph.pregel.ComputeFunction;
import org.apache.flink.graph.pregel.VertexCentricConfiguration;
import org.gradoop.common.model.impl.id.GradoopId;
import org.gradoop.common.model.impl.pojo.EPGMEdge;
import org.gradoop.common.model.impl.pojo.EPGMVertex;
import org.gradoop.flink.algorithms.gelly.BaseGellyAlgorithm;
import org.gradoop.flink.algorithms.gelly.randomjump.functions.EPGMEdgeWithGellyEdgeIdJoin;
import org.gradoop.flink.algorithms.gelly.randomjump.functions.GellyVertexWithEPGMVertexJoin;
import org.gradoop.flink.algorithms.gelly.randomjump.functions.GellyVertexWithLongIdToGradoopIdJoin;
import org.gradoop.flink.algorithms.gelly.randomjump.functions.GetVisitedGellyEdgeLongIdsFlatMap;
import org.gradoop.flink.algorithms.gelly.randomjump.functions.GetVisitedSourceTargetIdsFlatMap;
import org.gradoop.flink.algorithms.gelly.randomjump.functions.LongIdToGellyVertexWithVCIValueMap;
import org.gradoop.flink.algorithms.gelly.randomjump.functions.LongIdTupleToGellyEdgeWithLongValueJoin;
import org.gradoop.flink.algorithms.gelly.randomjump.functions.LongIdWithEdgeToTupleJoin;
import org.gradoop.flink.algorithms.gelly.randomjump.functions.ReplaceTargetWithLongIdJoin;
import org.gradoop.flink.algorithms.gelly.randomjump.functions.VCIComputeFunction;
import org.gradoop.flink.algorithms.gelly.randomjump.functions.VCIVertexValue;
import org.gradoop.flink.algorithms.gelly.randomjump.functions.VertexWithVisitedSourceTargetIdJoin;
import org.gradoop.flink.algorithms.gelly.randomjump.functions.VisitedGellyEdgesWithLongIdToGradoopIdJoin;
import org.gradoop.flink.model.impl.epgm.LogicalGraph;
import org.gradoop.flink.model.impl.functions.epgm.Id;
import org.gradoop.flink.model.impl.functions.epgm.SourceId;
import org.gradoop.flink.model.impl.functions.tuple.Value0Of2;

public class KRandomJumpGellyVCI
extends BaseGellyAlgorithm<Long, VCIVertexValue, Long, LogicalGraph> {
    protected LogicalGraph currentGraph;
    private final int numberOfStartVertices;
    private final int maxIterations;
    private final double jumpProbability;
    private final double percentageToVisit;
    private DataSet<Tuple2<Long, GradoopId>> indexToVertexIdMap;
    private DataSet<Tuple2<Long, GradoopId>> indexToEdgeIdMap;

    public KRandomJumpGellyVCI(int numberOfStartVertices, int maxIterations, double jumpProbability, double percentageToVisit) {
        Preconditions.checkArgument((numberOfStartVertices >= 1 ? 1 : 0) != 0, (Object)"at least 1 starting vertex is needed, numberOfStartVertices must be equal or greater 1");
        Preconditions.checkArgument((maxIterations > 0 ? 1 : 0) != 0, (Object)"maxIterations must be greater than 0");
        Preconditions.checkArgument((jumpProbability >= 0.0 && jumpProbability <= 1.0 ? 1 : 0) != 0, (Object)"jumpProbability must be equal/greater than 0.0 and smaller/equal 1.0");
        Preconditions.checkArgument((percentageToVisit > 0.0 && percentageToVisit <= 1.0 ? 1 : 0) != 0, (Object)"percentageToVisit must be greater than 0.0 and smaller/equal 1.0");
        this.numberOfStartVertices = numberOfStartVertices;
        this.maxIterations = maxIterations;
        this.jumpProbability = jumpProbability;
        this.percentageToVisit = percentageToVisit;
    }

    @Override
    public Graph<Long, VCIVertexValue, Long> transformToGelly(LogicalGraph graph) {
        this.currentGraph = graph;
        this.indexToVertexIdMap = DataSetUtils.zipWithIndex((DataSet)graph.getVertices().map(new Id()));
        this.indexToEdgeIdMap = DataSetUtils.zipWithIndex((DataSet)graph.getEdges().map(new Id()));
        MapOperator vertices = this.indexToVertexIdMap.map((MapFunction)new LongIdToGellyVertexWithVCIValueMap());
        JoinOperator.EquiJoin edges = graph.getEdges().join(this.indexToVertexIdMap).where(new SourceId()).equalTo(new int[]{1}).with((JoinFunction)new LongIdWithEdgeToTupleJoin()).join(this.indexToVertexIdMap).where(new int[]{1}).equalTo(new int[]{1}).with((JoinFunction)new ReplaceTargetWithLongIdJoin()).join(this.indexToEdgeIdMap).where(new int[]{2}).equalTo(new int[]{1}).with((JoinFunction)new LongIdTupleToGellyEdgeWithLongValueJoin());
        return Graph.fromDataSet((DataSet)vertices, (DataSet)edges, (ExecutionEnvironment)graph.getConfig().getExecutionEnvironment());
    }

    @Override
    public LogicalGraph executeInGelly(Graph<Long, VCIVertexValue, Long> gellyGraph) throws Exception {
        long vertexCount = gellyGraph.numberOfVertices();
        HashSet<Long> randomStartIndices = new HashSet<Long>();
        while (randomStartIndices.size() < this.numberOfStartVertices) {
            long randomLongInBounds = (long)(Math.random() * (double)(vertexCount - 1L));
            randomStartIndices.add(randomLongInBounds);
        }
        DataSource startIndices = this.currentGraph.getConfig().getExecutionEnvironment().fromCollection(randomStartIndices);
        long verticesToVisit = (long)Math.ceil((double)vertexCount * this.percentageToVisit);
        VertexCentricConfiguration parameters = new VertexCentricConfiguration();
        parameters.addBroadcastSet("startIndices", (DataSet)startIndices);
        parameters.addBroadcastSet("vertexIndices", (DataSet)this.indexToVertexIdMap.map(new Value0Of2()));
        parameters.registerAggregator("visitedVerticesAggregator", (Aggregator)new LongSumAggregator());
        Graph resultGraph = gellyGraph.runVertexCentricIteration((ComputeFunction)new VCIComputeFunction(this.jumpProbability, verticesToVisit), null, this.maxIterations, parameters);
        JoinOperator.EquiJoin visitedGellyEdgeIds = resultGraph.getVertices().flatMap((FlatMapFunction)new GetVisitedGellyEdgeLongIdsFlatMap()).join(this.indexToEdgeIdMap).where(new String[]{"*"}).equalTo(new int[]{0}).with((JoinFunction)new VisitedGellyEdgesWithLongIdToGradoopIdJoin());
        JoinOperator visitedEdges = this.currentGraph.getEdges().leftOuterJoin((DataSet)visitedGellyEdgeIds).where(new Id()).equalTo(new String[]{"*"}).with((JoinFunction)new EPGMEdgeWithGellyEdgeIdJoin("sampled"));
        DistinctOperator visitedSourceTargetIds = visitedEdges.flatMap((FlatMapFunction)new GetVisitedSourceTargetIdsFlatMap("sampled")).distinct();
        JoinOperator.EquiJoin visitedVertices = resultGraph.getVertices().join(this.indexToVertexIdMap).where(new int[]{0}).equalTo(new int[]{0}).with((JoinFunction)new GellyVertexWithLongIdToGradoopIdJoin()).join(this.currentGraph.getVertices()).where(new int[]{0}).equalTo(new Id()).with((JoinFunction)new GellyVertexWithEPGMVertexJoin("sampled"));
        visitedVertices = visitedVertices.leftOuterJoin((DataSet)visitedSourceTargetIds).where(new Id()).equalTo(new String[]{"*"}).with((JoinFunction)new VertexWithVisitedSourceTargetIdJoin("sampled"));
        return this.currentGraph.getFactory().fromDataSets(this.currentGraph.getGraphHead(), (DataSet<EPGMVertex>)visitedVertices, (DataSet<EPGMEdge>)visitedEdges);
    }
}

