/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.flink.algorithms.gelly.shortestpaths;

import org.apache.flink.api.common.functions.JoinFunction;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.operators.JoinOperator;
import org.apache.flink.graph.Graph;
import org.apache.flink.types.NullValue;
import org.gradoop.common.model.impl.id.GradoopId;
import org.gradoop.common.model.impl.pojo.EPGMVertex;
import org.gradoop.flink.algorithms.gelly.GradoopGellyAlgorithm;
import org.gradoop.flink.algorithms.gelly.functions.EdgeToGellyEdgeWithDouble;
import org.gradoop.flink.algorithms.gelly.functions.VertexToGellyVertexWithNullValue;
import org.gradoop.flink.algorithms.gelly.shortestpaths.functions.SingleSourceShortestPathsAttribute;
import org.gradoop.flink.model.impl.epgm.LogicalGraph;
import org.gradoop.flink.model.impl.functions.epgm.Id;

public class SingleSourceShortestPaths
extends GradoopGellyAlgorithm<NullValue, Double> {
    private final GradoopId srcVertexId;
    private final int iterations;
    private final String propertyKeyVertex;
    private final String propertyKeyEdge;

    public SingleSourceShortestPaths(GradoopId srcVertexId, String propertyKeyEdge, int iterations, String propertyKeyVertex) {
        super(new VertexToGellyVertexWithNullValue(), new EdgeToGellyEdgeWithDouble(propertyKeyEdge));
        this.propertyKeyVertex = propertyKeyVertex;
        this.propertyKeyEdge = propertyKeyEdge;
        this.iterations = iterations;
        this.srcVertexId = srcVertexId;
    }

    @Override
    public LogicalGraph executeInGelly(Graph<GradoopId, NullValue, Double> graph) {
        JoinOperator.EquiJoin newVertices = new org.apache.flink.graph.library.SingleSourceShortestPaths((Object)this.srcVertexId, Integer.valueOf(this.iterations)).run(graph).join(this.currentGraph.getVertices()).where(new int[]{0}).equalTo(new Id()).with((JoinFunction)new SingleSourceShortestPathsAttribute(this.propertyKeyVertex));
        return this.currentGraph.getFactory().fromDataSets(this.currentGraph.getGraphHead(), (DataSet<EPGMVertex>)newVertices, this.currentGraph.getEdges());
    }
}

