/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.flink.algorithms.gelly.trianglecounting;

import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.operators.MapOperator;
import org.apache.flink.graph.Graph;
import org.apache.flink.graph.library.TriangleEnumerator;
import org.apache.flink.types.NullValue;
import org.gradoop.common.model.impl.id.GradoopId;
import org.gradoop.common.model.impl.pojo.EPGMGraphHead;
import org.gradoop.common.model.impl.properties.PropertyValue;
import org.gradoop.flink.algorithms.gelly.GradoopGellyAlgorithm;
import org.gradoop.flink.algorithms.gelly.functions.EdgeToGellyEdgeWithNullValue;
import org.gradoop.flink.algorithms.gelly.functions.VertexToGellyVertexWithNullValue;
import org.gradoop.flink.algorithms.gelly.functions.WritePropertyToGraphHeadMap;
import org.gradoop.flink.model.impl.epgm.LogicalGraph;

public class GellyTriangleCounting
extends GradoopGellyAlgorithm<NullValue, NullValue> {
    public static final String PROPERTY_KEY_TRIANGLES = "triangle_count";

    public GellyTriangleCounting() {
        super(new VertexToGellyVertexWithNullValue(), new EdgeToGellyEdgeWithNullValue());
    }

    @Override
    public LogicalGraph executeInGelly(Graph<GradoopId, NullValue, NullValue> graph) throws Exception {
        DataSet triangles = new TriangleEnumerator().run(graph);
        MapOperator resultHead = this.currentGraph.getGraphHead().map((MapFunction)new WritePropertyToGraphHeadMap(PROPERTY_KEY_TRIANGLES, PropertyValue.create((Object)triangles.count())));
        return this.currentGraph.getFactory().fromDataSets((DataSet<EPGMGraphHead>)resultHead, this.currentGraph.getVertices(), this.currentGraph.getEdges());
    }
}

