/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.flink.algorithms.gelly.vertexdegrees;

import org.apache.flink.api.common.functions.JoinFunction;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.operators.JoinOperator;
import org.apache.flink.graph.Graph;
import org.apache.flink.graph.asm.degree.annotate.directed.VertexDegrees;
import org.apache.flink.types.NullValue;
import org.gradoop.common.model.impl.id.GradoopId;
import org.gradoop.common.model.impl.pojo.EPGMVertex;
import org.gradoop.flink.algorithms.gelly.GradoopGellyAlgorithm;
import org.gradoop.flink.algorithms.gelly.functions.EdgeToGellyEdgeWithNullValue;
import org.gradoop.flink.algorithms.gelly.functions.VertexToGellyVertexWithNullValue;
import org.gradoop.flink.algorithms.gelly.vertexdegrees.functions.DistinctVertexDegreesToAttribute;
import org.gradoop.flink.model.impl.epgm.LogicalGraph;
import org.gradoop.flink.model.impl.functions.epgm.Id;

public class DistinctVertexDegrees
extends GradoopGellyAlgorithm<NullValue, NullValue> {
    private final String propertyKey;
    private final String propertyKeyIn;
    private final String propertyKeyOut;
    private final boolean includeZeroDegreeVertices;

    public DistinctVertexDegrees(String propertyKey, String propertyKeyIn, String propertyKeyOut) {
        this(propertyKey, propertyKeyIn, propertyKeyOut, true);
    }

    public DistinctVertexDegrees(String propertyKey, String propertyKeyIn, String propertyKeyOut, boolean includeZeroDegreeVertices) {
        super(new VertexToGellyVertexWithNullValue(), new EdgeToGellyEdgeWithNullValue());
        this.propertyKey = propertyKey;
        this.propertyKeyIn = propertyKeyIn;
        this.propertyKeyOut = propertyKeyOut;
        this.includeZeroDegreeVertices = includeZeroDegreeVertices;
    }

    @Override
    public LogicalGraph executeInGelly(Graph<GradoopId, NullValue, NullValue> graph) throws Exception {
        JoinOperator.EquiJoin newVertices = new VertexDegrees().setIncludeZeroDegreeVertices(this.includeZeroDegreeVertices).run(graph).join(this.currentGraph.getVertices()).where(new int[]{0}).equalTo(new Id()).with((JoinFunction)new DistinctVertexDegreesToAttribute(this.propertyKey, this.propertyKeyIn, this.propertyKeyOut));
        return this.currentGraph.getFactory().fromDataSets(this.currentGraph.getGraphHead(), (DataSet<EPGMVertex>)newVertices, this.currentGraph.getEdges());
    }
}

