/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.flink.algorithms.gelly.vertexdegrees.functions;

import org.apache.flink.api.common.functions.JoinFunction;
import org.apache.flink.graph.Vertex;
import org.apache.flink.graph.asm.degree.annotate.directed.VertexDegrees;
import org.gradoop.common.model.impl.id.GradoopId;
import org.gradoop.common.model.impl.pojo.EPGMVertex;
import org.gradoop.common.model.impl.properties.PropertyValue;

public class DistinctVertexDegreesToAttribute
implements JoinFunction<Vertex<GradoopId, VertexDegrees.Degrees>, EPGMVertex, EPGMVertex> {
    private final String vertexDegreesProperty;
    private final String vertexInDegreeProperty;
    private final String vertexOutDegreeProperty;

    public DistinctVertexDegreesToAttribute(String vertexDegreesProperty, String vertexInDegreesProperty, String vertexOutDegreesProperty) {
        this.vertexDegreesProperty = vertexDegreesProperty;
        this.vertexInDegreeProperty = vertexInDegreesProperty;
        this.vertexOutDegreeProperty = vertexOutDegreesProperty;
    }

    public EPGMVertex join(Vertex<GradoopId, VertexDegrees.Degrees> degree, EPGMVertex vertex) throws Exception {
        vertex.setProperty(this.vertexDegreesProperty, PropertyValue.create((Object)((VertexDegrees.Degrees)degree.getValue()).getDegree().getValue()));
        vertex.setProperty(this.vertexInDegreeProperty, PropertyValue.create((Object)((VertexDegrees.Degrees)degree.getValue()).getInDegree().getValue()));
        vertex.setProperty(this.vertexOutDegreeProperty, PropertyValue.create((Object)((VertexDegrees.Degrees)degree.getValue()).getOutDegree().getValue()));
        return vertex;
    }
}

