/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.flink.io.api.metadata;

import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.common.functions.ReduceFunction;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.operators.MapOperator;
import org.apache.flink.api.java.tuple.Tuple3;
import org.apache.flink.api.java.typeutils.TupleTypeInfo;
import org.apache.hadoop.conf.Configuration;
import org.gradoop.common.model.api.entities.Element;
import org.gradoop.common.model.impl.metadata.MetaData;
import org.gradoop.flink.io.api.metadata.functions.ElementToPropertyMetaData;
import org.gradoop.flink.io.api.metadata.functions.ReducePropertyMetaData;
import org.gradoop.flink.model.api.epgm.BaseGraphCollection;
import org.gradoop.flink.model.impl.epgm.LogicalGraph;
import org.gradoop.flink.util.GradoopFlinkConfig;

public interface MetaDataSource<M extends MetaData> {
    public static final String GRAPH_TYPE = "g";
    public static final String VERTEX_TYPE = "v";
    public static final String EDGE_TYPE = "e";

    default public DataSet<Tuple3<String, String, String>> tuplesFromGraph(LogicalGraph graph) {
        return MetaDataSource.tuplesFromElements(graph.getVertices()).union(MetaDataSource.tuplesFromElements(graph.getEdges()));
    }

    default public DataSet<Tuple3<String, String, String>> tuplesFromCollection(BaseGraphCollection<?, ?, ?, ?, ?> graphs) {
        return MetaDataSource.tuplesFromElements(graphs.getVertices()).union(MetaDataSource.tuplesFromElements(graphs.getEdges())).union(MetaDataSource.tuplesFromElements(graphs.getGraphHeads()));
    }

    public static <E extends Element> DataSet<Tuple3<String, String, String>> tuplesFromElements(DataSet<E> elements) {
        return ((MapOperator)elements.map(new ElementToPropertyMetaData()).groupBy(new int[]{0, 1}).reduce((ReduceFunction)new ReducePropertyMetaData()).map((MapFunction & Serializable)tuple -> Tuple3.of((Object)tuple.f0, (Object)tuple.f1, (Object)((Set)tuple.f2).stream().sorted().collect(Collectors.joining(",")))).returns((TypeInformation)new TupleTypeInfo(new TypeInformation[]{BasicTypeInfo.STRING_TYPE_INFO, BasicTypeInfo.STRING_TYPE_INFO, BasicTypeInfo.STRING_TYPE_INFO}))).withForwardedFields(new String[]{"f0", "f1"});
    }

    public M fromTuples(List<Tuple3<String, String, String>> var1);

    public DataSet<Tuple3<String, String, String>> readDistributed(String var1, GradoopFlinkConfig var2);

    public M readLocal(String var1, Configuration var2) throws IOException;
}

