/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.flink.io.api.metadata.functions;

import java.util.HashSet;
import java.util.Set;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.java.functions.FunctionAnnotation;
import org.apache.flink.api.java.tuple.Tuple3;
import org.gradoop.common.model.api.entities.Edge;
import org.gradoop.common.model.api.entities.Element;
import org.gradoop.common.model.api.entities.GraphHead;
import org.gradoop.common.model.api.entities.Vertex;
import org.gradoop.common.model.impl.properties.Property;
import org.gradoop.flink.io.impl.csv.CSVConstants;
import org.gradoop.flink.io.impl.csv.functions.StringEscaper;
import org.gradoop.flink.io.impl.csv.metadata.CSVMetaDataParser;

@FunctionAnnotation.ForwardedFields(value={"label->f1"})
public class ElementToPropertyMetaData<E extends Element>
implements MapFunction<E, Tuple3<String, String, Set<String>>> {
    private final Tuple3<String, String, Set<String>> reuseTuple = new Tuple3();

    public ElementToPropertyMetaData() {
        this.reuseTuple.f2 = new HashSet();
    }

    public Tuple3<String, String, Set<String>> map(E e) throws Exception {
        if (e instanceof Edge) {
            this.reuseTuple.f0 = "e";
        } else if (e instanceof Vertex) {
            this.reuseTuple.f0 = "v";
        } else if (e instanceof GraphHead) {
            this.reuseTuple.f0 = "g";
        } else {
            throw new Exception("Unsupported element class: " + e.getClass().getName());
        }
        this.reuseTuple.f1 = StringEscaper.escape(e.getLabel(), CSVConstants.ESCAPED_CHARACTERS);
        ((Set)this.reuseTuple.f2).clear();
        if (e.getProperties() != null) {
            for (Property property : e.getProperties()) {
                ((Set)this.reuseTuple.f2).add(CSVMetaDataParser.getPropertyMetaData(property));
            }
        }
        return this.reuseTuple;
    }
}

