/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.flink.io.impl.csv;

import java.io.File;
import java.util.Objects;
import org.gradoop.flink.io.impl.csv.CSVConstants;
import org.gradoop.flink.io.impl.csv.functions.StringEscaper;
import org.gradoop.flink.io.impl.csv.indexed.functions.MultipleFileOutputFormat;
import org.gradoop.flink.util.GradoopFlinkConfig;

public abstract class CSVBase {
    public static final String BC_METADATA = "metadata";
    private static final String CSV_FILE_SUFFIX = ".csv";
    private static final String VERTEX_PATH = "vertices";
    private static final String VERTEX_FILE = "vertices.csv";
    private static final String GRAPH_HEAD_PATH = "graphs";
    private static final String GRAPH_HEAD_FILE = "graphs.csv";
    private static final String EDGE_PATH = "edges";
    private static final String EDGE_FILE = "edges.csv";
    private static final String METADATA_FILE = "metadata.csv";
    private final String csvRoot;
    private final GradoopFlinkConfig config;

    protected CSVBase(String csvPath, GradoopFlinkConfig config) {
        Objects.requireNonNull(csvPath);
        Objects.requireNonNull(config);
        this.csvRoot = csvPath.endsWith(File.separator) ? csvPath : csvPath + File.separator;
        this.config = config;
    }

    protected String getGraphHeadPath() {
        return this.csvRoot + GRAPH_HEAD_PATH;
    }

    protected String getVertexPath() {
        return this.csvRoot + VERTEX_PATH;
    }

    protected String getEdgePath() {
        return this.csvRoot + EDGE_PATH;
    }

    protected String getGraphHeadCSVPath() {
        return this.csvRoot + GRAPH_HEAD_FILE;
    }

    protected String getVertexCSVPath() {
        return this.csvRoot + VERTEX_FILE;
    }

    protected String getEdgeCSVPath() {
        return this.csvRoot + EDGE_FILE;
    }

    protected String getGraphHeadCSVPath(String label) {
        return this.getElementCSVPath(label, this.getGraphHeadPath());
    }

    protected String getVertexCSVPath(String label) {
        return this.getElementCSVPath(label, this.getVertexPath());
    }

    protected String getEdgeCSVPath(String label) {
        return this.getElementCSVPath(label, this.getEdgePath());
    }

    private String getElementCSVPath(String label, String elementPath) {
        Objects.requireNonNull(label);
        label = label.isEmpty() ? "_" : MultipleFileOutputFormat.cleanFilename(StringEscaper.escape(label, CSVConstants.ESCAPED_CHARACTERS));
        return elementPath + CSVConstants.DIRECTORY_SEPARATOR + label + CSVConstants.DIRECTORY_SEPARATOR + "data.csv";
    }

    protected String getMetaDataPath() {
        return this.csvRoot + METADATA_FILE;
    }

    protected GradoopFlinkConfig getConfig() {
        return this.config;
    }
}

