/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.flink.io.impl.csv;

import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.operators.SingleInputUdfOperator;
import org.apache.flink.api.java.tuple.Tuple3;
import org.gradoop.common.model.api.entities.Edge;
import org.gradoop.common.model.api.entities.GraphHead;
import org.gradoop.common.model.api.entities.Vertex;
import org.gradoop.common.model.impl.pojo.EPGMGraphHead;
import org.gradoop.flink.io.api.DataSource;
import org.gradoop.flink.io.impl.csv.CSVBase;
import org.gradoop.flink.io.impl.csv.functions.CSVLineToEdge;
import org.gradoop.flink.io.impl.csv.functions.CSVLineToElement;
import org.gradoop.flink.io.impl.csv.functions.CSVLineToGraphHead;
import org.gradoop.flink.io.impl.csv.functions.CSVLineToVertex;
import org.gradoop.flink.io.impl.csv.metadata.CSVMetaDataSource;
import org.gradoop.flink.model.api.epgm.BaseGraph;
import org.gradoop.flink.model.api.epgm.BaseGraphCollection;
import org.gradoop.flink.model.api.epgm.BaseGraphCollectionFactory;
import org.gradoop.flink.model.impl.epgm.GraphCollection;
import org.gradoop.flink.model.impl.epgm.GraphCollectionFactory;
import org.gradoop.flink.model.impl.epgm.LogicalGraph;
import org.gradoop.flink.util.GradoopFlinkConfig;

public class CSVDataSource
extends CSVBase
implements DataSource {
    public CSVDataSource(String csvPath, GradoopFlinkConfig config) {
        super(csvPath, config);
    }

    @Override
    public LogicalGraph getLogicalGraph() {
        GraphCollection collection = this.getGraphCollection();
        return collection.getGraphFactory().fromDataSets((DataSet<EPGMGraphHead>)collection.getGraphHeads().first(1), collection.getVertices(), collection.getEdges());
    }

    @Override
    public GraphCollection getGraphCollection() {
        GraphCollectionFactory collectionFactory = this.getConfig().getGraphCollectionFactory();
        return this.getCollection(new CSVLineToGraphHead(collectionFactory.getGraphHeadFactory()), new CSVLineToVertex(collectionFactory.getVertexFactory()), new CSVLineToEdge(collectionFactory.getEdgeFactory()), collectionFactory);
    }

    protected <G extends GraphHead, V extends Vertex, E extends Edge, LG extends BaseGraph<G, V, E, LG, GC>, GC extends BaseGraphCollection<G, V, E, LG, GC>> GC getCollection(CSVLineToElement<G> csvToGraphHead, CSVLineToElement<V> csvToVertex, CSVLineToElement<E> csvToEdge, BaseGraphCollectionFactory<G, V, E, LG, GC> collectionFactory) {
        DataSet<Tuple3<String, String, String>> metaData = new CSVMetaDataSource().readDistributed(this.getMetaDataPath(), this.getConfig());
        SingleInputUdfOperator graphHeads = this.getConfig().getExecutionEnvironment().readTextFile(this.getGraphHeadCSVPath()).map(csvToGraphHead).withBroadcastSet(metaData, "metadata");
        SingleInputUdfOperator vertices = this.getConfig().getExecutionEnvironment().readTextFile(this.getVertexCSVPath()).map(csvToVertex).withBroadcastSet(metaData, "metadata");
        SingleInputUdfOperator edges = this.getConfig().getExecutionEnvironment().readTextFile(this.getEdgeCSVPath()).map(csvToEdge).withBroadcastSet(metaData, "metadata");
        return collectionFactory.fromDataSets((DataSet<G>)graphHeads, (DataSet<V>)vertices, (DataSet<E>)edges);
    }
}

