/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.flink.io.impl.csv.functions;

import java.util.List;
import org.apache.flink.api.common.functions.RichMapFunction;
import org.apache.flink.configuration.Configuration;
import org.gradoop.common.model.api.entities.Element;
import org.gradoop.common.model.impl.id.GradoopId;
import org.gradoop.common.model.impl.id.GradoopIdSet;
import org.gradoop.common.model.impl.metadata.PropertyMetaData;
import org.gradoop.common.model.impl.properties.Properties;
import org.gradoop.flink.io.impl.csv.functions.StringEscaper;
import org.gradoop.flink.io.impl.csv.metadata.CSVMetaData;
import org.gradoop.flink.io.impl.csv.metadata.CSVMetaDataSource;

public abstract class CSVLineToElement<E extends Element>
extends RichMapFunction<String, E> {
    private final Properties properties = Properties.create();
    private CSVMetaData metaData;

    public void open(Configuration parameters) throws Exception {
        super.open(parameters);
        this.metaData = new CSVMetaDataSource().fromTuples(this.getRuntimeContext().getBroadcastVariable("metadata"));
    }

    protected Properties parseProperties(String type, String label, String propertyValueString) {
        String[] propertyValues = StringEscaper.split(propertyValueString, "|");
        List<PropertyMetaData> metaDataList = this.metaData.getPropertyMetaData(type, label);
        this.properties.clear();
        for (int i = 0; i < propertyValues.length; ++i) {
            if (propertyValues[i].length() <= 0) continue;
            this.properties.set(metaDataList.get(i).getKey(), metaDataList.get(i).getValueParser().apply(propertyValues[i]));
        }
        return this.properties;
    }

    protected GradoopIdSet parseGradoopIds(String gradoopIdsString) {
        String[] gradoopIds = gradoopIdsString.substring(1, gradoopIdsString.length() - 1).split(",");
        GradoopIdSet gradoopIdSet = new GradoopIdSet();
        for (String g : gradoopIds) {
            gradoopIdSet.add(GradoopId.fromString((String)g.trim()));
        }
        return gradoopIdSet;
    }

    public String[] split(String s, int limit) {
        return StringEscaper.split(s, ";", limit);
    }
}

