/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.flink.io.impl.csv.functions;

import java.util.Collection;
import org.apache.flink.api.java.functions.FunctionAnnotation;
import org.gradoop.common.model.impl.pojo.EPGMEdge;
import org.gradoop.flink.io.impl.csv.CSVConstants;
import org.gradoop.flink.io.impl.csv.functions.ElementToCSV;
import org.gradoop.flink.io.impl.csv.functions.StringEscaper;
import org.gradoop.flink.io.impl.csv.tuples.CSVEdge;

@FunctionAnnotation.ForwardedFields(value={"label->f4"})
public class EdgeToCSVEdge
extends ElementToCSV<EPGMEdge, CSVEdge> {
    private final CSVEdge csvEdge = new CSVEdge();

    public CSVEdge map(EPGMEdge edge) throws Exception {
        this.csvEdge.setId(edge.getId().toString());
        this.csvEdge.setGradoopIds(this.collectionToCsvString((Collection<?>)edge.getGraphIds()));
        this.csvEdge.setSourceId(edge.getSourceId().toString());
        this.csvEdge.setTargetId(edge.getTargetId().toString());
        this.csvEdge.setLabel(StringEscaper.escape(edge.getLabel(), CSVConstants.ESCAPED_CHARACTERS));
        this.csvEdge.setProperties(this.getPropertyString(edge, "e"));
        return this.csvEdge;
    }
}

