/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.flink.io.impl.csv.functions;

import java.util.Collection;
import java.util.stream.Collectors;
import org.apache.flink.api.common.functions.RichMapFunction;
import org.apache.flink.api.java.tuple.Tuple;
import org.apache.flink.configuration.Configuration;
import org.gradoop.common.model.impl.metadata.MetaData;
import org.gradoop.common.model.impl.metadata.PropertyMetaData;
import org.gradoop.common.model.impl.pojo.EPGMElement;
import org.gradoop.common.model.impl.properties.PropertyValue;
import org.gradoop.flink.io.impl.csv.CSVConstants;
import org.gradoop.flink.io.impl.csv.functions.StringEscaper;
import org.gradoop.flink.io.impl.csv.metadata.CSVMetaData;
import org.gradoop.flink.io.impl.csv.metadata.CSVMetaDataSource;

public abstract class ElementToCSV<E extends EPGMElement, T extends Tuple>
extends RichMapFunction<E, T> {
    private static final String EMPTY_STRING = "";
    private CSVMetaData metaData;

    public void open(Configuration parameters) throws Exception {
        super.open(parameters);
        this.metaData = new CSVMetaDataSource().fromTuples(this.getRuntimeContext().getBroadcastVariable("metadata"));
    }

    protected String getPropertyString(E element, String type) {
        return this.metaData.getPropertyMetaData(type, element.getLabel()).stream().map(propertyMetaData -> this.getPropertyValueString((PropertyMetaData)propertyMetaData, element)).collect(Collectors.joining("|"));
    }

    private String getPropertyValueString(PropertyMetaData propertyMetaData, E element) {
        PropertyValue p = element.getPropertyValue(propertyMetaData.getKey());
        if (p != null && MetaData.getTypeString((PropertyValue)p).equals(propertyMetaData.getTypeString())) {
            return this.propertyValueToCsvString(p);
        }
        return EMPTY_STRING;
    }

    private String propertyValueToCsvString(PropertyValue p) {
        if (p.isList() || p.isSet()) {
            return this.collectionToCsvString((Collection)p.getObject());
        }
        if (p.isMap()) {
            return p.getMap().entrySet().stream().map(e -> ElementToCSV.escape((PropertyValue)e.getKey()) + "=" + ElementToCSV.escape((PropertyValue)e.getValue())).collect(Collectors.joining(",", "{", "}"));
        }
        return ElementToCSV.escape(p);
    }

    protected String collectionToCsvString(Collection<?> collection) {
        return collection.stream().map(o -> o instanceof PropertyValue ? ElementToCSV.escape((PropertyValue)o) : o.toString()).collect(Collectors.joining(",", "[", "]"));
    }

    private static String escape(PropertyValue propertyValue) {
        if (propertyValue.isString()) {
            return StringEscaper.escape(propertyValue.toString(), CSVConstants.ESCAPED_CHARACTERS);
        }
        return propertyValue.toString();
    }
}

