/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.flink.io.impl.csv.functions;

import org.apache.flink.api.java.functions.FunctionAnnotation;
import org.gradoop.common.model.impl.pojo.EPGMGraphHead;
import org.gradoop.flink.io.impl.csv.CSVConstants;
import org.gradoop.flink.io.impl.csv.functions.ElementToCSV;
import org.gradoop.flink.io.impl.csv.functions.StringEscaper;
import org.gradoop.flink.io.impl.csv.tuples.CSVGraphHead;

@FunctionAnnotation.ForwardedFields(value={"label->f1"})
public class GraphHeadToCSVGraphHead
extends ElementToCSV<EPGMGraphHead, CSVGraphHead> {
    private final CSVGraphHead csvGraphHead = new CSVGraphHead();

    public CSVGraphHead map(EPGMGraphHead graphHead) throws Exception {
        this.csvGraphHead.setId(graphHead.getId().toString());
        this.csvGraphHead.setLabel(StringEscaper.escape(graphHead.getLabel(), CSVConstants.ESCAPED_CHARACTERS));
        this.csvGraphHead.setProperties(this.getPropertyString(graphHead, "g"));
        return this.csvGraphHead;
    }
}

