/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.flink.io.impl.csv.functions;

import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import java.util.ArrayList;
import java.util.Set;

public class StringEscaper {
    private static final char ESCAPE_CHARACTER = '\\';
    private static final BiMap<Character, CharSequence> CUSTOM_ESCAPE_SEQUENCES = new ImmutableBiMap.Builder().put((Object)Character.valueOf('\t'), (Object)String.format("%c%c", Character.valueOf('\\'), Character.valueOf('t'))).put((Object)Character.valueOf('\b'), (Object)String.format("%c%c", Character.valueOf('\\'), Character.valueOf('b'))).put((Object)Character.valueOf('\n'), (Object)String.format("%c%c", Character.valueOf('\\'), Character.valueOf('n'))).put((Object)Character.valueOf('\r'), (Object)String.format("%c%c", Character.valueOf('\\'), Character.valueOf('r'))).put((Object)Character.valueOf('\f'), (Object)String.format("%c%c", Character.valueOf('\\'), Character.valueOf('f'))).build();

    public static String escape(String string, Set<Character> escapedCharacters) {
        StringBuilder sb = new StringBuilder();
        for (char c : string.toCharArray()) {
            if (escapedCharacters.contains(Character.valueOf(c))) {
                sb.append(StringEscaper.escapeCharacter(c));
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static String unescape(String escapedString) {
        StringBuilder sb = new StringBuilder();
        boolean escaped = false;
        for (int i = 0; i < escapedString.length(); ++i) {
            if (escaped) {
                escaped = false;
                sb.append(StringEscaper.unescapeSequence(escapedString.subSequence(i - 1, i + 1)));
                continue;
            }
            if (escapedString.charAt(i) == '\\') {
                escaped = true;
                continue;
            }
            sb.append(escapedString.charAt(i));
        }
        return sb.toString();
    }

    public static String[] split(String escapedString, String delimiter) throws IllegalArgumentException {
        return StringEscaper.split(escapedString, delimiter, 0);
    }

    public static String[] split(String escapedString, String delimiter, int limit) throws IllegalArgumentException {
        if (delimiter.contains(Character.toString('\\'))) {
            throw new IllegalArgumentException(String.format("Delimiter must not contain the escape character: '%c'", Character.valueOf('\\')));
        }
        if (limit <= 0) {
            limit = escapedString.length() + 1;
        }
        ArrayList<String> tokens = new ArrayList<String>();
        StringBuilder sb = new StringBuilder();
        boolean escaped = false;
        int delimiterIndex = 0;
        for (char c : escapedString.toCharArray()) {
            if (!escaped && c == delimiter.charAt(delimiterIndex)) {
                if (++delimiterIndex != delimiter.length()) continue;
                if (tokens.size() < limit - 1) {
                    tokens.add(sb.toString());
                    sb.setLength(0);
                } else {
                    sb.append(delimiter, 0, delimiterIndex);
                }
                delimiterIndex = 0;
                continue;
            }
            sb.append(delimiter, 0, delimiterIndex);
            delimiterIndex = 0;
            if (escaped) {
                escaped = false;
            } else if (c == '\\') {
                escaped = true;
            }
            sb.append(c);
        }
        sb.append(delimiter, 0, delimiterIndex);
        tokens.add(sb.toString());
        return tokens.toArray(new String[0]);
    }

    private static CharSequence escapeCharacter(char character) {
        if (CUSTOM_ESCAPE_SEQUENCES.containsKey((Object)Character.valueOf(character))) {
            return (CharSequence)CUSTOM_ESCAPE_SEQUENCES.get((Object)Character.valueOf(character));
        }
        return String.format("%c%c", Character.valueOf('\\'), Character.valueOf(character));
    }

    private static char unescapeSequence(CharSequence sequence) {
        if (CUSTOM_ESCAPE_SEQUENCES.containsValue((Object)sequence)) {
            return ((Character)CUSTOM_ESCAPE_SEQUENCES.inverse().get((Object)sequence)).charValue();
        }
        return sequence.charAt(1);
    }
}

