/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.flink.io.impl.csv.functions;

import java.util.Collection;
import org.apache.flink.api.java.functions.FunctionAnnotation;
import org.gradoop.common.model.impl.pojo.EPGMVertex;
import org.gradoop.flink.io.impl.csv.CSVConstants;
import org.gradoop.flink.io.impl.csv.functions.ElementToCSV;
import org.gradoop.flink.io.impl.csv.functions.StringEscaper;
import org.gradoop.flink.io.impl.csv.tuples.CSVVertex;

@FunctionAnnotation.ForwardedFields(value={"label->f2"})
public class VertexToCSVVertex
extends ElementToCSV<EPGMVertex, CSVVertex> {
    private final CSVVertex csvVertex = new CSVVertex();

    public CSVVertex map(EPGMVertex vertex) throws Exception {
        this.csvVertex.setId(vertex.getId().toString());
        this.csvVertex.setGradoopIds(this.collectionToCsvString((Collection<?>)vertex.getGraphIds()));
        this.csvVertex.setLabel(StringEscaper.escape(vertex.getLabel(), CSVConstants.ESCAPED_CHARACTERS));
        this.csvVertex.setProperties(this.getPropertyString(vertex, "v"));
        return this.csvVertex;
    }
}

