/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.flink.io.impl.csv.indexed;

import java.io.IOException;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.operators.SingleInputUdfOperator;
import org.apache.flink.api.java.tuple.Tuple3;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.fs.Path;
import org.gradoop.flink.io.api.DataSink;
import org.gradoop.flink.io.impl.csv.CSVBase;
import org.gradoop.flink.io.impl.csv.CSVConstants;
import org.gradoop.flink.io.impl.csv.functions.EdgeToCSVEdge;
import org.gradoop.flink.io.impl.csv.functions.GraphHeadToCSVGraphHead;
import org.gradoop.flink.io.impl.csv.functions.VertexToCSVVertex;
import org.gradoop.flink.io.impl.csv.indexed.functions.IndexedCSVFileFormat;
import org.gradoop.flink.io.impl.csv.metadata.CSVMetaDataSink;
import org.gradoop.flink.io.impl.csv.metadata.CSVMetaDataSource;
import org.gradoop.flink.model.impl.epgm.GraphCollection;
import org.gradoop.flink.model.impl.epgm.LogicalGraph;
import org.gradoop.flink.util.GradoopFlinkConfig;

public class IndexedCSVDataSink
extends CSVBase
implements DataSink {
    private final String metaDataPath;

    public IndexedCSVDataSink(String csvPath, GradoopFlinkConfig config) {
        this(csvPath, null, config);
    }

    public IndexedCSVDataSink(String csvPath, String metaDataPath, GradoopFlinkConfig config) {
        super(csvPath, config);
        this.metaDataPath = metaDataPath;
    }

    @Override
    public void write(LogicalGraph logicalGraph) throws IOException {
        this.write(logicalGraph, false);
    }

    @Override
    public void write(GraphCollection graphCollection) throws IOException {
        this.write(graphCollection, false);
    }

    @Override
    public void write(LogicalGraph logicalGraph, boolean overwrite) throws IOException {
        this.write(logicalGraph.getCollectionFactory().fromGraph(logicalGraph), overwrite);
    }

    @Override
    public void write(GraphCollection graphCollection, boolean overwrite) throws IOException {
        FileSystem.WriteMode writeMode = overwrite ? FileSystem.WriteMode.OVERWRITE : FileSystem.WriteMode.NO_OVERWRITE;
        CSVMetaDataSource source = new CSVMetaDataSource();
        DataSet<Tuple3<String, String, String>> metaData = !this.reuseMetadata() ? source.tuplesFromCollection(graphCollection) : source.readDistributed(this.metaDataPath, this.getConfig());
        SingleInputUdfOperator csvGraphHeads = graphCollection.getGraphHeads().map((MapFunction)new GraphHeadToCSVGraphHead()).withBroadcastSet(metaData, "metadata");
        SingleInputUdfOperator csvVertices = graphCollection.getVertices().map((MapFunction)new VertexToCSVVertex()).withBroadcastSet(metaData, "metadata");
        SingleInputUdfOperator csvEdges = graphCollection.getEdges().map((MapFunction)new EdgeToCSVEdge()).withBroadcastSet(metaData, "metadata");
        if (!this.getMetaDataPath().equals(this.metaDataPath) || !this.reuseMetadata()) {
            new CSVMetaDataSink().writeDistributed(this.getMetaDataPath(), metaData, writeMode);
        }
        IndexedCSVFileFormat graphHeadFormat = new IndexedCSVFileFormat(new Path(this.getGraphHeadPath()), CSVConstants.ROW_DELIMITER, ";");
        graphHeadFormat.setWriteMode(writeMode);
        csvGraphHeads.output(graphHeadFormat);
        IndexedCSVFileFormat vertexFormat = new IndexedCSVFileFormat(new Path(this.getVertexPath()), CSVConstants.ROW_DELIMITER, ";");
        vertexFormat.setWriteMode(writeMode);
        csvVertices.output(vertexFormat);
        IndexedCSVFileFormat edgeFormat = new IndexedCSVFileFormat(new Path(this.getEdgePath()), CSVConstants.ROW_DELIMITER, ";");
        edgeFormat.setWriteMode(writeMode);
        csvEdges.output(edgeFormat);
    }

    private boolean reuseMetadata() {
        return this.metaDataPath != null && !this.metaDataPath.isEmpty();
    }
}

