/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.flink.io.impl.csv.indexed;

import java.io.IOException;
import java.io.Serializable;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.flink.api.common.functions.FilterFunction;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.api.java.operators.FilterOperator;
import org.apache.flink.api.java.operators.MapOperator;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.api.java.tuple.Tuple3;
import org.apache.hadoop.conf.Configuration;
import org.gradoop.flink.io.api.DataSource;
import org.gradoop.flink.io.impl.csv.CSVBase;
import org.gradoop.flink.io.impl.csv.functions.CSVLineToEdge;
import org.gradoop.flink.io.impl.csv.functions.CSVLineToGraphHead;
import org.gradoop.flink.io.impl.csv.functions.CSVLineToVertex;
import org.gradoop.flink.io.impl.csv.metadata.CSVMetaData;
import org.gradoop.flink.io.impl.csv.metadata.CSVMetaDataSource;
import org.gradoop.flink.model.impl.epgm.GraphCollection;
import org.gradoop.flink.model.impl.epgm.GraphCollectionFactory;
import org.gradoop.flink.model.impl.epgm.LogicalGraph;
import org.gradoop.flink.model.impl.operators.combination.ReduceCombination;
import org.gradoop.flink.util.GradoopFlinkConfig;

public class IndexedCSVDataSource
extends CSVBase
implements DataSource {
    private final Configuration hdfsConfig;

    public IndexedCSVDataSource(String csvPath, GradoopFlinkConfig config) {
        this(csvPath, config, new Configuration());
    }

    public IndexedCSVDataSource(String csvPath, GradoopFlinkConfig conf, Configuration hdfsConf) {
        super(csvPath, conf);
        Objects.requireNonNull(hdfsConf);
        this.hdfsConfig = hdfsConf;
    }

    @Override
    public LogicalGraph getLogicalGraph() throws IOException {
        return (LogicalGraph)this.getGraphCollection().reduce(new ReduceCombination());
    }

    @Override
    public GraphCollection getGraphCollection() throws IOException {
        CSVMetaDataSource source = new CSVMetaDataSource();
        CSVMetaData metaData = source.readLocal(this.getMetaDataPath(), this.hdfsConfig);
        DataSet<Tuple3<String, String, String>> metaDataBroadcast = source.readDistributed(this.getMetaDataPath(), this.getConfig());
        ExecutionEnvironment env = this.getConfig().getExecutionEnvironment();
        GraphCollectionFactory factory = this.getConfig().getGraphCollectionFactory();
        Map<String, DataSet> graphHeads = metaData.getGraphLabels().stream().map(label -> Tuple2.of((Object)label, (Object)((MapOperator)env.readTextFile(this.getGraphHeadCSVPath((String)label)).map((MapFunction)new CSVLineToGraphHead(factory.getGraphHeadFactory())).withBroadcastSet(metaDataBroadcast, "metadata")).filter((FilterFunction & Serializable)graphHead -> graphHead.getLabel().equals(label)))).collect(Collectors.toMap(t -> (String)t.f0, t -> (FilterOperator)t.f1));
        Map<String, DataSet> vertices = metaData.getVertexLabels().stream().map(label -> Tuple2.of((Object)label, (Object)((MapOperator)env.readTextFile(this.getVertexCSVPath((String)label)).map((MapFunction)new CSVLineToVertex(factory.getVertexFactory())).withBroadcastSet(metaDataBroadcast, "metadata")).filter((FilterFunction & Serializable)vertex -> vertex.getLabel().equals(label)))).collect(Collectors.toMap(t -> (String)t.f0, t -> (FilterOperator)t.f1));
        Map<String, DataSet> edges = metaData.getEdgeLabels().stream().map(label -> Tuple2.of((Object)label, (Object)((MapOperator)env.readTextFile(this.getEdgeCSVPath((String)label)).map((MapFunction)new CSVLineToEdge(factory.getEdgeFactory())).withBroadcastSet(metaDataBroadcast, "metadata")).filter((FilterFunction & Serializable)edge -> edge.getLabel().equals(label)))).collect(Collectors.toMap(t -> (String)t.f0, t -> (FilterOperator)t.f1));
        return factory.fromIndexedDataSets(graphHeads, vertices, edges);
    }
}

