/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.flink.io.impl.csv.indexed.functions;

import org.apache.flink.api.common.io.OutputFormat;
import org.apache.flink.api.java.io.CsvOutputFormat;
import org.apache.flink.api.java.tuple.Tuple;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.fs.Path;
import org.gradoop.flink.io.impl.csv.CSVConstants;
import org.gradoop.flink.io.impl.csv.indexed.functions.MultipleFileOutputFormat;
import org.gradoop.flink.io.impl.csv.tuples.CSVElement;

public class IndexedCSVFileFormat<T extends Tuple>
extends MultipleFileOutputFormat<T> {
    public static final String DEFAULT_LINE_DELIMITER = CSVConstants.ROW_DELIMITER;
    public static final String DEFAULT_FIELD_DELIMITER = ";";
    private String fieldDelimiter;
    private String recordDelimiter;
    private String charsetName = null;

    public IndexedCSVFileFormat(Path outputPath) {
        this(outputPath, DEFAULT_LINE_DELIMITER, DEFAULT_FIELD_DELIMITER);
    }

    public IndexedCSVFileFormat(Path outputPath, String fieldDelimiter) {
        this(outputPath, DEFAULT_LINE_DELIMITER, fieldDelimiter);
    }

    public IndexedCSVFileFormat(Path outputPath, String recordDelimiter, String fieldDelimiter) {
        super(outputPath);
        if (recordDelimiter == null) {
            throw new IllegalArgumentException("RecordDelmiter shall not be null.");
        }
        if (fieldDelimiter == null) {
            throw new IllegalArgumentException("FieldDelimiter shall not be null.");
        }
        this.fieldDelimiter = fieldDelimiter;
        this.recordDelimiter = recordDelimiter;
    }

    public void setCharsetName(String charsetName) {
        this.charsetName = charsetName;
    }

    @Override
    protected OutputFormat<T> createFormatForDirectory(Path directory) {
        CsvOutputFormat format = new CsvOutputFormat(directory, this.recordDelimiter, this.fieldDelimiter);
        format.setWriteMode(FileSystem.WriteMode.NO_OVERWRITE);
        if (this.charsetName != null) {
            format.setCharsetName(this.charsetName);
        }
        format.configure(this.configuration);
        return format;
    }

    @Override
    protected String getDirectoryForRecord(T record) {
        String label = ((CSVElement)record).getLabel();
        if (label.isEmpty()) {
            return IndexedCSVFileFormat.cleanFilename("_") + "/" + "data.csv";
        }
        return IndexedCSVFileFormat.cleanFilename(label) + "/" + "data.csv";
    }
}

