/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.flink.io.impl.csv.indexed.functions;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.flink.api.common.io.CleanupWhenUnsuccessful;
import org.apache.flink.api.common.io.InitializeOnMaster;
import org.apache.flink.api.common.io.OutputFormat;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.fs.Path;

public abstract class MultipleFileOutputFormat<IT>
implements OutputFormat<IT>,
CleanupWhenUnsuccessful,
InitializeOnMaster {
    protected Configuration configuration;
    protected FileSystem.WriteMode writeMode;
    protected int taskNumber;
    protected int numTasks;
    protected int parallelism;
    protected Path rootOutputPath;
    private Map<String, OutputFormat<IT>> formatsPerSubdirectory;

    MultipleFileOutputFormat(Path rootPath) {
        this.rootOutputPath = rootPath;
        this.formatsPerSubdirectory = new HashMap<String, OutputFormat<IT>>();
    }

    public void close() throws IOException {
        for (OutputFormat<IT> outputFormat : this.formatsPerSubdirectory.values()) {
            outputFormat.close();
        }
        this.formatsPerSubdirectory.clear();
    }

    public void configure(Configuration parameters) {
        this.configuration = parameters;
    }

    public void initializeGlobal(int parallelism) throws IOException {
        this.parallelism = parallelism;
        FileSystem fs = this.rootOutputPath.getFileSystem();
        if (fs.isDistributedFS()) {
            if (!fs.initOutPathDistFS(this.rootOutputPath, this.writeMode, true)) {
                throw new IOException("Failed to initialize output root directory: " + this.rootOutputPath);
            }
        } else {
            if (this.writeMode == FileSystem.WriteMode.OVERWRITE) {
                try {
                    fs.delete(this.rootOutputPath, true);
                }
                catch (IOException e) {
                    throw new IOException("Could not remove existing output root directory: " + this.rootOutputPath, e);
                }
            }
            if (!fs.initOutPathLocalFS(this.rootOutputPath, this.writeMode, true)) {
                throw new IOException("Failed to initialize output root directory: " + this.rootOutputPath);
            }
        }
    }

    public void open(int taskNumber, int numTasks) {
        this.taskNumber = taskNumber;
        this.numTasks = numTasks;
    }

    public void setWriteMode(FileSystem.WriteMode writeMode) {
        this.writeMode = writeMode;
    }

    public void tryCleanupOnError() throws Exception {
        for (OutputFormat<IT> outputFormat : this.formatsPerSubdirectory.values()) {
            if (!(outputFormat instanceof CleanupWhenUnsuccessful)) continue;
            ((CleanupWhenUnsuccessful)outputFormat).tryCleanupOnError();
        }
        this.rootOutputPath.getFileSystem().delete(this.rootOutputPath, false);
    }

    public void writeRecord(IT record) throws IOException {
        OutputFormat<IT> format;
        String subDirectory = this.getDirectoryForRecord(record);
        if (this.formatsPerSubdirectory.containsKey(subDirectory)) {
            format = this.formatsPerSubdirectory.get(subDirectory);
        } else {
            format = this.createFormatForDirectory(new Path(this.rootOutputPath, subDirectory));
            format.open(this.taskNumber, this.numTasks);
            this.formatsPerSubdirectory.put(subDirectory, format);
        }
        format.writeRecord(record);
    }

    protected abstract OutputFormat<IT> createFormatForDirectory(Path var1) throws IOException;

    protected abstract String getDirectoryForRecord(IT var1);

    public static String cleanFilename(String filename) {
        return filename.replaceAll("[<>:\"/\\\\|?*]", "_").toLowerCase();
    }
}

