/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.flink.io.impl.csv.metadata;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.gradoop.common.model.impl.id.GradoopId;
import org.gradoop.common.model.impl.metadata.MetaData;
import org.gradoop.common.model.impl.properties.Property;
import org.gradoop.common.model.impl.properties.PropertyValue;
import org.gradoop.common.model.impl.properties.Type;
import org.gradoop.flink.io.impl.csv.CSVConstants;
import org.gradoop.flink.io.impl.csv.functions.StringEscaper;

public class CSVMetaDataParser {
    private static final Map<String, Function<String, Object>> SIMPLE_TYPE_PARSER_MAP = CSVMetaDataParser.getSimpleTypeParserMap();

    private static Map<String, Function<String, Object>> getSimpleTypeParserMap() {
        HashMap<String, Function<String, Object>> map = new HashMap<String, Function<String, Object>>();
        map.put(Type.SHORT.toString(), Short::parseShort);
        map.put(Type.INTEGER.toString(), Integer::parseInt);
        map.put(Type.LONG.toString(), Long::parseLong);
        map.put(Type.FLOAT.toString(), Float::parseFloat);
        map.put(Type.DOUBLE.toString(), Double::parseDouble);
        map.put(Type.BOOLEAN.toString(), Boolean::parseBoolean);
        map.put(Type.STRING.toString(), StringEscaper::unescape);
        map.put(Type.BIG_DECIMAL.toString(), BigDecimal::new);
        map.put(Type.GRADOOP_ID.toString(), GradoopId::fromString);
        map.put(Type.DATE.toString(), LocalDate::parse);
        map.put(Type.TIME.toString(), LocalTime::parse);
        map.put(Type.DATE_TIME.toString(), LocalDateTime::parse);
        map.put(Type.NULL.toString(), CSVMetaDataParser::parseNullProperty);
        return Collections.unmodifiableMap(map);
    }

    public static String getPropertyMetaData(Property property) {
        return String.format("%s%s%s", StringEscaper.escape(property.getKey(), CSVConstants.ESCAPED_CHARACTERS), ":", MetaData.getTypeString((PropertyValue)property.getValue()));
    }

    static Function<String, Object> getPropertyValueParser(String propertyType) {
        String[] typeTokens = StringEscaper.split(propertyType.toLowerCase(), ":");
        String mainType = typeTokens[0];
        if (mainType.equals(Type.LIST.toString())) {
            return CSVMetaDataParser.getListValueParser(typeTokens);
        }
        if (mainType.equals(Type.SET.toString())) {
            return CSVMetaDataParser.getSetValueParser(typeTokens);
        }
        if (mainType.equals(Type.MAP.toString())) {
            return CSVMetaDataParser.getMapValueParser(typeTokens);
        }
        if (SIMPLE_TYPE_PARSER_MAP.containsKey(mainType)) {
            return SIMPLE_TYPE_PARSER_MAP.get(mainType);
        }
        throw new TypeNotPresentException(mainType, null);
    }

    private static Function<String, Object> getListValueParser(String[] listTypeTokens) {
        if (listTypeTokens.length != 2) {
            throw new IllegalArgumentException("Item type of List type is missing");
        }
        String itemType = listTypeTokens[1];
        if (!SIMPLE_TYPE_PARSER_MAP.containsKey(itemType)) {
            throw new TypeNotPresentException(itemType, null);
        }
        return s -> CSVMetaDataParser.parseListProperty(s, SIMPLE_TYPE_PARSER_MAP.get(itemType));
    }

    private static Function<String, Object> getMapValueParser(String[] mapTypeTokens) {
        if (mapTypeTokens.length != 3) {
            throw new IllegalArgumentException("Key type or value type of Map type is missing");
        }
        String keyType = mapTypeTokens[1];
        if (!SIMPLE_TYPE_PARSER_MAP.containsKey(keyType)) {
            throw new TypeNotPresentException(keyType, null);
        }
        String valueType = mapTypeTokens[2];
        if (!SIMPLE_TYPE_PARSER_MAP.containsKey(valueType)) {
            throw new TypeNotPresentException(valueType, null);
        }
        return s -> CSVMetaDataParser.parseMapProperty(s, SIMPLE_TYPE_PARSER_MAP.get(keyType), SIMPLE_TYPE_PARSER_MAP.get(valueType));
    }

    private static Function<String, Object> getSetValueParser(String[] setTypeTokens) {
        if (setTypeTokens.length != 2) {
            throw new IllegalArgumentException("Item type of Set type is missing");
        }
        String itemType = setTypeTokens[1];
        if (!SIMPLE_TYPE_PARSER_MAP.containsKey(itemType)) {
            throw new TypeNotPresentException(itemType, null);
        }
        return s -> CSVMetaDataParser.parseSetProperty(s, SIMPLE_TYPE_PARSER_MAP.get(itemType));
    }

    private static Object parseListProperty(String s, Function<String, Object> itemParser) {
        s = s.substring(1, s.length() - 1);
        return Arrays.stream(StringEscaper.split(s, ",")).map(itemParser).map(PropertyValue::create).collect(Collectors.toList());
    }

    private static Object parseMapProperty(String s, Function<String, Object> keyParser, Function<String, Object> valueParser) {
        s = s.substring(1, s.length() - 1);
        return Arrays.stream(StringEscaper.split(s, ",")).map(st -> StringEscaper.split(st, "=")).map(strings -> new Object[]{keyParser.apply(strings[0]), valueParser.apply(strings[1])}).collect(Collectors.toMap(e -> PropertyValue.create((Object)e[0]), e -> PropertyValue.create((Object)e[1])));
    }

    private static Object parseSetProperty(String s, Function<String, Object> itemParser) {
        s = s.substring(1, s.length() - 1);
        return Arrays.stream(StringEscaper.split(s, ",")).map(itemParser).map(PropertyValue::create).collect(Collectors.toSet());
    }

    private static Object parseNullProperty(String nullString) throws IllegalArgumentException {
        if (nullString != null && nullString.equalsIgnoreCase(Type.NULL.toString())) {
            return null;
        }
        throw new IllegalArgumentException("Only null represents a null string.");
    }
}

