/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.flink.io.impl.csv.metadata;

import java.io.IOException;
import java.util.List;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.tuple.Tuple3;
import org.apache.flink.core.fs.FileSystem;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.gradoop.common.model.impl.metadata.PropertyMetaData;
import org.gradoop.flink.io.api.metadata.MetaDataSink;
import org.gradoop.flink.io.impl.csv.CSVConstants;
import org.gradoop.flink.io.impl.csv.metadata.CSVMetaData;

public class CSVMetaDataSink
implements MetaDataSink<CSVMetaData> {
    @Override
    public void writeDistributed(String metaDataPath, DataSet<Tuple3<String, String, String>> metaDataTuples, FileSystem.WriteMode writeMode) {
        metaDataTuples.writeAsCsv(metaDataPath, CSVConstants.ROW_DELIMITER, ";", writeMode).setParallelism(1);
    }

    @Override
    public void writeLocal(String metaDataPath, CSVMetaData metaData, Configuration hdfsConfig, boolean overwrite) throws IOException {
        try (FileSystem fs = FileSystem.get((Configuration)hdfsConfig);){
            Path file = new Path(metaDataPath);
            if (fs.exists(file)) {
                if (!overwrite) {
                    return;
                }
                fs.delete(file, false);
            }
            try (FSDataOutputStream outputStream = fs.create(file);){
                for (String graphLabel : metaData.getGraphLabels()) {
                    outputStream.writeBytes(this.constructMetaDataString("g", graphLabel, metaData.getGraphPropertyMetaData(graphLabel)));
                    outputStream.writeBytes(CSVConstants.ROW_DELIMITER);
                }
                for (String vertexLabel : metaData.getVertexLabels()) {
                    outputStream.writeBytes(this.constructMetaDataString("v", vertexLabel, metaData.getVertexPropertyMetaData(vertexLabel)));
                    outputStream.writeBytes(CSVConstants.ROW_DELIMITER);
                }
                for (String edgeLabel : metaData.getEdgeLabels()) {
                    outputStream.writeBytes(this.constructMetaDataString("e", edgeLabel, metaData.getEdgePropertyMetaData(edgeLabel)));
                    outputStream.writeBytes(CSVConstants.ROW_DELIMITER);
                }
                outputStream.flush();
            }
        }
    }

    private String constructMetaDataString(String entityPrefix, String label, List<PropertyMetaData> propertyMetaData) {
        StringBuilder metaDataBuilder = new StringBuilder();
        metaDataBuilder.append(entityPrefix);
        metaDataBuilder.append(";");
        metaDataBuilder.append(label);
        metaDataBuilder.append(";");
        for (int i = 0; i < propertyMetaData.size(); ++i) {
            PropertyMetaData property = propertyMetaData.get(i);
            metaDataBuilder.append(property.getKey());
            metaDataBuilder.append(":");
            metaDataBuilder.append(property.getTypeString());
            if (i >= propertyMetaData.size() - 1) continue;
            metaDataBuilder.append(",");
        }
        return metaDataBuilder.toString();
    }
}

