/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.flink.io.impl.csv.metadata;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.common.typeinfo.TypeHint;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.tuple.Tuple3;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.gradoop.common.model.impl.metadata.MetaData;
import org.gradoop.common.model.impl.metadata.PropertyMetaData;
import org.gradoop.flink.io.api.metadata.MetaDataSource;
import org.gradoop.flink.io.impl.csv.functions.StringEscaper;
import org.gradoop.flink.io.impl.csv.metadata.CSVMetaData;
import org.gradoop.flink.io.impl.csv.metadata.CSVMetaDataParser;
import org.gradoop.flink.util.GradoopFlinkConfig;

public class CSVMetaDataSource
implements MetaDataSource<CSVMetaData> {
    @Override
    public CSVMetaData fromTuples(List<Tuple3<String, String, String>> metaDataStrings) {
        HashMap<String, List<PropertyMetaData>> graphMetaDataMap = new HashMap<String, List<PropertyMetaData>>(metaDataStrings.size());
        HashMap<String, List<PropertyMetaData>> vertexMetaDataMap = new HashMap<String, List<PropertyMetaData>>(metaDataStrings.size());
        HashMap<String, List<PropertyMetaData>> edgeMetaDataMap = new HashMap<String, List<PropertyMetaData>>(metaDataStrings.size());
        block10: for (Tuple3<String, String, String> tuple : metaDataStrings) {
            ArrayList<PropertyMetaData> propertyMetaDataList;
            if (((String)tuple.f2).length() > 0) {
                String[] propertyStrings = StringEscaper.split((String)tuple.f2, ",");
                propertyMetaDataList = new ArrayList(propertyStrings.length);
                for (String propertyMetaData : propertyStrings) {
                    String[] propertyMetaDataTokens = StringEscaper.split(propertyMetaData, ":", 2);
                    propertyMetaDataList.add(new PropertyMetaData(StringEscaper.unescape(propertyMetaDataTokens[0]), propertyMetaDataTokens[1], CSVMetaDataParser.getPropertyValueParser(propertyMetaDataTokens[1])));
                }
            } else {
                propertyMetaDataList = new ArrayList<PropertyMetaData>(0);
            }
            String label = StringEscaper.unescape((String)tuple.f1);
            switch ((String)tuple.f0) {
                case "g": {
                    graphMetaDataMap.put(label, propertyMetaDataList);
                    continue block10;
                }
                case "v": {
                    vertexMetaDataMap.put(label, propertyMetaDataList);
                    continue block10;
                }
                case "e": {
                    edgeMetaDataMap.put(label, propertyMetaDataList);
                    continue block10;
                }
            }
            throw new IllegalArgumentException("Type " + (String)tuple.f0 + " is not a valid epgm type string. Valid strings are g, v and e.");
        }
        return new CSVMetaData(graphMetaDataMap, vertexMetaDataMap, edgeMetaDataMap);
    }

    @Override
    public DataSet<Tuple3<String, String, String>> readDistributed(String path, GradoopFlinkConfig config) {
        return config.getExecutionEnvironment().readTextFile(path).map((MapFunction & Serializable)line -> StringEscaper.split(line, ";", 3)).map((MapFunction & Serializable)tokens -> Tuple3.of((Object)tokens[0], (Object)tokens[1], (Object)tokens[2])).returns((TypeHint)new TypeHint<Tuple3<String, String, String>>(){});
    }

    @Override
    public CSVMetaData readLocal(String path, Configuration hdfsConfig) throws IOException {
        FileSystem fs = FileSystem.get((Configuration)hdfsConfig);
        Path file = new Path(path);
        Charset charset = StandardCharsets.UTF_8;
        if (!fs.exists(file)) {
            throw new FileNotFoundException(path);
        }
        try (BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)fs.open(file), charset));){
            MetaData metaData = this.fromTuples(br.lines().map(line -> StringEscaper.split(line, ";", 3)).map(tokens -> Tuple3.of((Object)tokens[0], (Object)tokens[1], (Object)tokens[2])).collect(Collectors.toList()));
            return metaData;
        }
    }
}

