/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.flink.io.impl.dot;

import java.io.IOException;
import java.util.Objects;
import org.apache.flink.api.common.io.OutputFormat;
import org.apache.flink.api.java.io.TextOutputFormat;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.fs.Path;
import org.gradoop.flink.io.api.DataSink;
import org.gradoop.flink.io.impl.dot.functions.AbstractDotFileFormat;
import org.gradoop.flink.io.impl.dot.functions.DotFileFormatHtml;
import org.gradoop.flink.io.impl.dot.functions.DotFileFormatSimple;
import org.gradoop.flink.model.impl.epgm.GraphCollection;
import org.gradoop.flink.model.impl.epgm.LogicalGraph;

public class DOTDataSink
implements DataSink {
    private final String path;
    private final boolean graphInformation;
    private final DotFormat format;

    public DOTDataSink(String path, boolean graphInformation) {
        this(path, graphInformation, DotFormat.HTML);
    }

    public DOTDataSink(String path, boolean graphInformation, DotFormat format) {
        this.path = Objects.requireNonNull(path);
        this.graphInformation = graphInformation;
        this.format = Objects.requireNonNull(format);
    }

    @Override
    public void write(LogicalGraph logicalGraph) throws IOException {
        this.write(logicalGraph, false);
    }

    @Override
    public void write(GraphCollection graphCollection) throws IOException {
        this.write(graphCollection, false);
    }

    @Override
    public void write(LogicalGraph graph, boolean overwrite) throws IOException {
        this.write(graph.getCollectionFactory().fromGraph(graph), overwrite);
    }

    @Override
    public void write(GraphCollection graphCollection, boolean overwrite) throws IOException {
        FileSystem.WriteMode writeMode = overwrite ? FileSystem.WriteMode.OVERWRITE : FileSystem.WriteMode.NO_OVERWRITE;
        AbstractDotFileFormat dotFileFormat = this.format.getDotFileFormat(this.graphInformation);
        GraphvizWriter graphvizWriter = new GraphvizWriter(new Path(this.path));
        graphvizWriter.setWriteMode(writeMode);
        graphCollection.getGraphTransactions().map(dotFileFormat::format).output((OutputFormat)graphvizWriter).setParallelism(1);
    }

    public static enum DotFormat {
        HTML,
        SIMPLE;


        public AbstractDotFileFormat getDotFileFormat(boolean printGraphHeadInformation) {
            String htmlColorGrey = "AAAAAAA";
            switch (this) {
                case SIMPLE: {
                    return new DotFileFormatSimple(printGraphHeadInformation);
                }
            }
            return new DotFileFormatHtml(printGraphHeadInformation, htmlColorGrey);
        }
    }

    private static class GraphvizWriter
    extends TextOutputFormat<String> {
        private static final long serialVersionUID = 1L;

        GraphvizWriter(Path outputPath) {
            super(outputPath);
        }

        public void open(int taskNumber, int numTasks) throws IOException {
            super.open(taskNumber, numTasks);
            super.writeRecord((Object)"digraph {\n");
        }

        public void close() throws IOException {
            super.writeRecord((Object)"}");
            super.close();
        }
    }
}

