/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.flink.io.impl.dot.functions;

import org.apache.flink.api.java.io.TextOutputFormat;
import org.gradoop.common.model.api.entities.Element;
import org.gradoop.common.model.impl.id.GradoopId;
import org.gradoop.common.model.impl.pojo.EPGMEdge;
import org.gradoop.common.model.impl.pojo.EPGMGraphHead;
import org.gradoop.flink.model.impl.layouts.transactional.tuples.GraphTransaction;

public abstract class AbstractDotFileFormat
implements TextOutputFormat.TextFormatter<GraphTransaction> {
    static final String VERTEX_ID_PREFIX = "v";
    private static final long serialVersionUID = 1L;
    private boolean printGraphHead;

    public String format(GraphTransaction transaction) {
        StringBuilder builder = new StringBuilder();
        GradoopId id = transaction.getGraphHead().getId();
        builder.append("subgraph cluster_g").append(id).append("{\n");
        if (this.printGraphHead) {
            this.writeGraphHead(transaction, builder);
        }
        this.writeVertices(transaction, builder, id.toString());
        this.writeEdges(transaction, builder, id.toString());
        builder.append("}\n");
        return builder.toString();
    }

    private void writeGraphHead(GraphTransaction transaction, StringBuilder builder) {
        EPGMGraphHead graphHead = transaction.getGraphHead();
        this.writeLabel(builder, (Element)graphHead);
        builder.append(";\n");
    }

    abstract void writeVertices(GraphTransaction var1, StringBuilder var2, String var3);

    private void writeEdges(GraphTransaction transaction, StringBuilder builder, String suffix) {
        for (EPGMEdge edge : transaction.getEdges()) {
            builder.append(VERTEX_ID_PREFIX).append(edge.getSourceId()).append(suffix).append("->").append(VERTEX_ID_PREFIX).append(edge.getTargetId()).append(suffix).append(" [");
            this.writeLabel(builder, (Element)edge);
            builder.append("];\n");
        }
    }

    abstract void writeLabel(StringBuilder var1, Element var2);

    void setPrintGraphHead(boolean printGraphHead) {
        this.printGraphHead = printGraphHead;
    }
}

