/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.flink.io.impl.dot.functions;

import com.google.common.base.Preconditions;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.gradoop.common.model.api.entities.Element;
import org.gradoop.common.model.impl.pojo.EPGMVertex;
import org.gradoop.common.model.impl.properties.Properties;
import org.gradoop.common.model.impl.properties.Property;
import org.gradoop.flink.io.impl.dot.functions.AbstractDotFileFormat;
import org.gradoop.flink.model.impl.layouts.transactional.tuples.GraphTransaction;

public class DotFileFormatHtml
extends AbstractDotFileFormat {
    private String color;

    public DotFileFormatHtml(boolean printGraphHead, String color) {
        this.setPrintGraphHead(printGraphHead);
        this.color = (String)Preconditions.checkNotNull((Object)color, (Object)"Color was null");
    }

    @Override
    void writeVertices(GraphTransaction transaction, StringBuilder builder, String suffix) {
        for (EPGMVertex vertex : transaction.getVertices()) {
            builder.append("v").append(vertex.getId()).append(suffix).append(" [shape=Mrecord, ");
            this.writeLabel(builder, (Element)vertex);
            builder.append("];\n");
        }
    }

    @Override
    void writeLabel(StringBuilder builder, Element elem) {
        String lbl;
        String label = elem.getLabel();
        String id = elem.getId().toString();
        Properties properties = elem.getProperties();
        String string = lbl = StringUtils.isEmpty((CharSequence)label) ? id : label;
        if (properties != null && properties.size() > 0) {
            builder.append("label=<").append("<font color=\"").append(this.color).append("\">").append("<table border=\"0\" cellborder=\"0\" cellpadding=\"3\">").append("<tr><td colspan=\"2\" bgcolor=\"").append(this.color).append("\"><font color=\"white\">").append(StringEscapeUtils.escapeHtml4((String)lbl)).append("</font></td></tr>");
            for (Property property : properties) {
                builder.append("<tr><td>").append(StringEscapeUtils.escapeHtml4((String)property.getKey())).append("</td><td>").append(StringEscapeUtils.escapeHtml4((String)property.getValue().toString())).append("</td></tr>");
            }
            builder.append("</table></font>>");
        } else {
            builder.append("label=\"").append(StringEscapeUtils.escapeHtml4((String)lbl)).append("\"");
        }
    }
}

