/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.flink.io.impl.dot.functions;

import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.gradoop.common.model.api.entities.Element;
import org.gradoop.common.model.impl.pojo.EPGMVertex;
import org.gradoop.common.model.impl.properties.Properties;
import org.gradoop.common.model.impl.properties.Property;
import org.gradoop.flink.io.impl.dot.functions.AbstractDotFileFormat;
import org.gradoop.flink.model.impl.layouts.transactional.tuples.GraphTransaction;

public class DotFileFormatSimple
extends AbstractDotFileFormat {
    public DotFileFormatSimple(boolean printGraphHead) {
        this.setPrintGraphHead(printGraphHead);
    }

    @Override
    void writeVertices(GraphTransaction transaction, StringBuilder builder, String suffix) {
        for (EPGMVertex vertex : transaction.getVertices()) {
            builder.append("v").append(vertex.getId()).append(suffix).append(" [");
            this.writeLabel(builder, (Element)vertex);
            builder.append("];\n");
        }
    }

    @Override
    void writeLabel(StringBuilder builder, Element element) {
        String label = StringUtils.isEmpty((CharSequence)element.getLabel()) ? element.getId().toString() : element.getLabel();
        Properties properties = element.getProperties();
        if (properties != null && properties.size() > 0) {
            builder.append("label=\"").append(StringEscapeUtils.escapeJava((String)label)).append("\"");
            for (Property property : properties) {
                builder.append(",").append(StringEscapeUtils.escapeJava((String)property.getKey())).append("=\"").append(StringEscapeUtils.escapeJava((String)property.getValue().toString())).append("\"");
            }
        } else {
            builder.append("label=\"").append(StringEscapeUtils.escapeJava((String)label)).append("\"");
        }
    }
}

