/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.flink.io.impl.edgelist;

import java.io.IOException;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.api.java.operators.MapOperator;
import org.apache.flink.api.java.utils.DataSetUtils;
import org.gradoop.flink.io.api.DataSource;
import org.gradoop.flink.io.impl.edgelist.functions.CreateImportEdge;
import org.gradoop.flink.io.impl.edgelist.functions.CreateImportVertex;
import org.gradoop.flink.io.impl.graph.GraphDataSource;
import org.gradoop.flink.model.impl.epgm.GraphCollection;
import org.gradoop.flink.model.impl.epgm.LogicalGraph;
import org.gradoop.flink.model.impl.operators.combination.ReduceCombination;
import org.gradoop.flink.util.GradoopFlinkConfig;

public class EdgeListDataSource
implements DataSource {
    private String edgeListPath;
    private String tokenSeparator;
    private GradoopFlinkConfig config;

    public EdgeListDataSource(String edgeListPath, String tokenSeparator, GradoopFlinkConfig config) {
        this.edgeListPath = edgeListPath;
        this.tokenSeparator = tokenSeparator;
        this.config = config;
    }

    @Override
    public LogicalGraph getLogicalGraph() throws IOException {
        return (LogicalGraph)this.getGraphCollection().reduce(new ReduceCombination());
    }

    @Override
    public GraphCollection getGraphCollection() throws IOException {
        ExecutionEnvironment env = this.getConfig().getExecutionEnvironment();
        org.apache.flink.api.java.operators.DataSource lineTuples = env.readCsvFile(this.getEdgeListPath()).fieldDelimiter(this.getTokenSeparator()).types(Long.class, Long.class);
        MapOperator importVertices = lineTuples.project(new int[]{0}).union((DataSet)lineTuples.project(new int[]{1})).distinct().map(new CreateImportVertex());
        MapOperator importEdges = DataSetUtils.zipWithUniqueId((DataSet)lineTuples).map(new CreateImportEdge());
        return new GraphDataSource(importVertices, importEdges, this.getConfig()).getGraphCollection();
    }

    GradoopFlinkConfig getConfig() {
        return this.config;
    }

    String getEdgeListPath() {
        return this.edgeListPath;
    }

    String getTokenSeparator() {
        return this.tokenSeparator;
    }
}

