/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.flink.io.impl.edgelist;

import java.io.IOException;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.api.java.operators.DataSource;
import org.apache.flink.api.java.operators.MapOperator;
import org.apache.flink.api.java.utils.DataSetUtils;
import org.gradoop.flink.io.impl.edgelist.EdgeListDataSource;
import org.gradoop.flink.io.impl.edgelist.functions.CreateImportEdge;
import org.gradoop.flink.io.impl.edgelist.functions.CreateLabeledImportVertex;
import org.gradoop.flink.io.impl.graph.GraphDataSource;
import org.gradoop.flink.model.impl.epgm.GraphCollection;
import org.gradoop.flink.model.impl.epgm.LogicalGraph;
import org.gradoop.flink.model.impl.operators.combination.ReduceCombination;
import org.gradoop.flink.util.GradoopFlinkConfig;

public class VertexLabeledEdgeListDataSource
extends EdgeListDataSource {
    private String propertyKey;

    public VertexLabeledEdgeListDataSource(String edgeListPath, String tokenSeparator, String propertyKey, GradoopFlinkConfig config) {
        super(edgeListPath, tokenSeparator, config);
        this.propertyKey = propertyKey;
    }

    @Override
    public LogicalGraph getLogicalGraph() throws IOException {
        return (LogicalGraph)this.getGraphCollection().reduce(new ReduceCombination());
    }

    @Override
    public GraphCollection getGraphCollection() throws IOException {
        ExecutionEnvironment env = this.getConfig().getExecutionEnvironment();
        DataSource lineTuples = env.readCsvFile(this.getEdgeListPath()).fieldDelimiter(this.getTokenSeparator()).types(Long.class, String.class, Long.class, String.class);
        MapOperator importVertices = lineTuples.project(new int[]{0, 1}).union((DataSet)lineTuples.project(new int[]{2, 3})).distinct(new int[]{0}).map(new CreateLabeledImportVertex(this.propertyKey));
        MapOperator importEdges = DataSetUtils.zipWithUniqueId((DataSet)lineTuples.project(new int[]{0, 2})).map(new CreateImportEdge());
        return new GraphDataSource(importVertices, importEdges, this.getConfig()).getGraphCollection();
    }
}

