/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.flink.io.impl.gdl;

import java.util.ArrayList;
import org.apache.flink.api.common.io.OutputFormat;
import org.apache.flink.api.java.io.LocalCollectionOutputFormat;
import org.gradoop.common.model.api.entities.Edge;
import org.gradoop.common.model.api.entities.GraphHead;
import org.gradoop.common.model.api.entities.Vertex;
import org.gradoop.flink.io.impl.gdl.GDLEncoder;
import org.gradoop.flink.model.api.epgm.BaseGraph;
import org.gradoop.flink.model.api.epgm.BaseGraphCollection;

public class GDLConsoleOutput {
    public static <G extends GraphHead, V extends Vertex, E extends Edge, LG extends BaseGraph<G, V, E, LG, GC>, GC extends BaseGraphCollection<G, V, E, LG, GC>> void print(BaseGraph<G, V, E, LG, GC> graph) throws Exception {
        GDLConsoleOutput.print(graph.getCollectionFactory().fromGraph(graph));
    }

    public static <G extends GraphHead, V extends Vertex, E extends Edge, LG extends BaseGraph<G, V, E, LG, GC>, GC extends BaseGraphCollection<G, V, E, LG, GC>> void print(BaseGraphCollection<G, V, E, LG, GC> collection) throws Exception {
        ArrayList graphHeads = new ArrayList();
        collection.getGraphHeads().output((OutputFormat)new LocalCollectionOutputFormat(graphHeads));
        ArrayList vertices = new ArrayList();
        collection.getVertices().output((OutputFormat)new LocalCollectionOutputFormat(vertices));
        ArrayList edges = new ArrayList();
        collection.getEdges().output((OutputFormat)new LocalCollectionOutputFormat(edges));
        collection.getConfig().getExecutionEnvironment().execute();
        GDLEncoder encoder = new GDLEncoder(graphHeads, vertices, edges);
        String graphString = encoder.getGDLString();
        System.out.println(graphString);
    }
}

