/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.flink.io.impl.gdl;

import java.io.IOException;
import org.apache.flink.api.common.functions.GroupReduceFunction;
import org.apache.flink.api.common.io.OutputFormat;
import org.apache.flink.api.java.io.TextOutputFormat;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.fs.Path;
import org.gradoop.flink.io.api.DataSink;
import org.gradoop.flink.io.impl.gdl.functions.GraphTransactionsToGDL;
import org.gradoop.flink.model.impl.epgm.GraphCollection;
import org.gradoop.flink.model.impl.epgm.LogicalGraph;

public class GDLDataSink
implements DataSink {
    private String path;

    public GDLDataSink(String path) {
        this.path = path;
    }

    @Override
    public void write(LogicalGraph logicalGraph) throws IOException {
        this.write(logicalGraph, false);
    }

    @Override
    public void write(GraphCollection graphCollection) throws IOException {
        this.write(graphCollection, false);
    }

    @Override
    public void write(LogicalGraph logicalGraph, boolean overwrite) throws IOException {
        this.write(logicalGraph.getCollectionFactory().fromGraph(logicalGraph), overwrite);
    }

    @Override
    public void write(GraphCollection graphCollection, boolean overwrite) throws IOException {
        FileSystem.WriteMode writeMode = overwrite ? FileSystem.WriteMode.OVERWRITE : FileSystem.WriteMode.NO_OVERWRITE;
        TextOutputFormat textOutputFormat = new TextOutputFormat(new Path(this.path));
        textOutputFormat.setWriteMode(writeMode);
        graphCollection.getGraphTransactions().reduceGroup((GroupReduceFunction)new GraphTransactionsToGDL()).output((OutputFormat)textOutputFormat).setParallelism(1);
    }
}

