/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.flink.io.impl.gdl;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.gradoop.common.model.api.entities.Edge;
import org.gradoop.common.model.api.entities.GraphHead;
import org.gradoop.common.model.api.entities.Vertex;
import org.gradoop.common.model.impl.id.GradoopId;
import org.gradoop.common.model.impl.properties.Properties;
import org.gradoop.common.model.impl.properties.Property;
import org.gradoop.common.model.impl.properties.PropertyValue;

public class GDLEncoder<G extends GraphHead, V extends Vertex, E extends Edge> {
    private static final String GRAPH_ELEMENTS_DEFINITION_START = "[";
    private static final String GRAPH_ELEMENTS_DEFINITION_END = "]";
    private static final String GRAPH_VARIABLE_PREFIX = "g";
    private static final String VERTEX_VARIABLE_PREFIX = "v";
    private static final String EDGE_VARIABLE_PREFIX = "e";
    private static final String PROPERTIES_PREFIX = "{";
    private static final String PROPERTIES_SUFFIX = "}";
    private static final String PROPERTIES_SEPARATOR = ",";
    private static final String KEY_VALUE_SEPARATOR = ":";
    private static final String DOUBLE_SUFFIX = "d";
    private static final String FLOAT_SUFFIX = "f";
    private static final String LONG_SUFFIX = "L";
    private static final String NULL_STRING = "NULL";
    private static final String STRING_PREFIX = "\"";
    private static final String STRING_SUFFIX = "\"";
    private List<G> graphHeads;
    private List<V> vertices;
    private List<E> edges;

    public GDLEncoder(List<G> graphHeads, List<V> vertices, List<E> edges) {
        this.graphHeads = graphHeads;
        this.vertices = vertices;
        this.edges = edges;
    }

    public String getGDLString() {
        Map<GradoopId, String> idToGraphHeadName = this.getGraphHeadNameMapping(this.graphHeads);
        Map<GradoopId, String> idToVertexName = this.getVertexNameMapping(this.vertices);
        Map<GradoopId, String> idToEdgeName = this.getEdgeNameMapping(this.edges);
        HashSet<GradoopId> usedVertexIds = new HashSet<GradoopId>();
        HashSet<GradoopId> usedEdgeIds = new HashSet<GradoopId>();
        StringBuilder result = new StringBuilder();
        for (GraphHead graphHead : this.graphHeads) {
            StringBuilder verticesString = new StringBuilder();
            StringBuilder edgesString = new StringBuilder();
            for (Vertex vertex : this.vertices) {
                boolean firstOccurrence;
                boolean containedInGraph = vertex.getGraphIds().contains((Object)graphHead.getId());
                boolean bl = firstOccurrence = !usedVertexIds.contains(vertex.getId());
                if (!containedInGraph) continue;
                String vertexString = this.vertexToGDLString(vertex, idToVertexName, firstOccurrence);
                usedVertexIds.add(vertex.getId());
                verticesString.append(vertexString).append(System.lineSeparator());
            }
            for (Edge edge : this.edges) {
                if (!edge.getGraphIds().contains((Object)graphHead.getId())) continue;
                boolean firstOccurrence = !usedEdgeIds.contains(edge.getId());
                String edgeString = this.edgeToGDLString(edge, idToVertexName, idToEdgeName, firstOccurrence);
                usedEdgeIds.add(edge.getId());
                edgesString.append(edgeString).append(System.lineSeparator());
            }
            result.append(this.graphHeadToGDLString(graphHead, idToGraphHeadName)).append(GRAPH_ELEMENTS_DEFINITION_START).append(System.lineSeparator()).append((CharSequence)verticesString).append(edgesString.length() > 0 ? System.lineSeparator() : "").append((CharSequence)edgesString).append(GRAPH_ELEMENTS_DEFINITION_END).append(System.lineSeparator()).append(System.lineSeparator());
        }
        return result.toString();
    }

    private Map<GradoopId, String> getGraphHeadNameMapping(List<G> graphHeads) {
        HashMap<GradoopId, String> idToGraphHeadName = new HashMap<GradoopId, String>(graphHeads.size());
        for (int i = 0; i < graphHeads.size(); ++i) {
            GraphHead graphHead = (GraphHead)graphHeads.get(i);
            String gName = String.format("%s%s", GRAPH_VARIABLE_PREFIX, i);
            idToGraphHeadName.put(graphHead.getId(), gName);
        }
        return idToGraphHeadName;
    }

    private Map<GradoopId, String> getVertexNameMapping(List<V> vertices) {
        HashMap<GradoopId, String> idToVertexName = new HashMap<GradoopId, String>(vertices.size());
        for (int i = 0; i < vertices.size(); ++i) {
            Vertex vertex = (Vertex)vertices.get(i);
            String vName = String.format("%s_%s_%s", VERTEX_VARIABLE_PREFIX, vertex.getLabel(), i);
            idToVertexName.put(vertex.getId(), vName);
        }
        return idToVertexName;
    }

    private Map<GradoopId, String> getEdgeNameMapping(List<E> edges) {
        HashMap<GradoopId, String> idToEdgeName = new HashMap<GradoopId, String>(edges.size());
        for (int i = 0; i < edges.size(); ++i) {
            Edge edge = (Edge)edges.get(i);
            String eName = String.format("%s_%s_%s", EDGE_VARIABLE_PREFIX, edge.getLabel(), i);
            idToEdgeName.put(edge.getId(), eName);
        }
        return idToEdgeName;
    }

    private String graphHeadToGDLString(G graphhead, Map<GradoopId, String> idToGraphHeadName) {
        return String.format("%s:%s %s", idToGraphHeadName.get(graphhead.getId()), graphhead.getLabel(), this.propertiesToGDLString(graphhead.getProperties()));
    }

    private String vertexToGDLString(V vertex, Map<GradoopId, String> idToVertexName, boolean firstOccurrence) {
        if (firstOccurrence) {
            return String.format("(%s:%s %s)", idToVertexName.get(vertex.getId()), vertex.getLabel(), this.propertiesToGDLString(vertex.getProperties()));
        }
        return String.format("(%s)", idToVertexName.get(vertex.getId()));
    }

    private String edgeToGDLString(E edge, Map<GradoopId, String> idToVertexName, Map<GradoopId, String> idToEdgeName, boolean firstOccurrence) {
        String result = firstOccurrence ? String.format("(%s)-[%s:%s%s]->(%s)", idToVertexName.get(edge.getSourceId()), idToEdgeName.get(edge.getId()), edge.getLabel(), this.propertiesToGDLString(edge.getProperties()), idToVertexName.get(edge.getTargetId())) : String.format("(%s)-[%s]->(%s)", idToVertexName.get(edge.getSourceId()), idToEdgeName.get(edge.getId()), idToVertexName.get(edge.getTargetId()));
        return result;
    }

    private String propertiesToGDLString(Properties properties) {
        if (properties == null || properties.isEmpty()) {
            return "";
        }
        return properties.toList().stream().map(this::propertyToGDLString).collect(Collectors.joining(PROPERTIES_SEPARATOR, PROPERTIES_PREFIX, PROPERTIES_SUFFIX));
    }

    private String propertyToGDLString(Property property) {
        StringBuilder result = new StringBuilder().append(property.getKey()).append(KEY_VALUE_SEPARATOR);
        PropertyValue value = property.getValue();
        if (value.isString()) {
            result.append("\"").append(value.toString()).append("\"");
        } else if (value.isNull()) {
            result.append(NULL_STRING);
        } else if (value.isDouble()) {
            result.append(value.toString()).append(DOUBLE_SUFFIX);
        } else if (value.isFloat()) {
            result.append(value.toString()).append(FLOAT_SUFFIX);
        } else if (value.isLong()) {
            result.append(value.toString()).append(LONG_SUFFIX);
        } else {
            result.append(value.toString());
        }
        return result.toString();
    }
}

